"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.cacheInvalidating = exports.cachedOperation = exports.clearCache = void 0;
const lodash_1 = __importDefault(require("lodash"));
const cache = {};
function clearCache(invalidateCacheKeyPrefix) {
    for (const methodName in cache) {
        const cacheKeys = Object.keys(cache[methodName]);
        for (const cacheKey of cacheKeys) {
            if (cacheKey.startsWith(invalidateCacheKeyPrefix)) {
                delete cache[methodName][cacheKey];
            }
        }
    }
}
exports.clearCache = clearCache;
function cachedOperation(keyCallback) {
    return function (_target, propertyKey, descriptor) {
        cache[propertyKey] = cache[propertyKey] || {};
        const originalMethod = descriptor.value;
        descriptor.value = function (...args) {
            return __awaiter(this, void 0, void 0, function* () {
                const cacheKey = keyCallback(this, ...args);
                if (cacheKey in cache[propertyKey]) {
                    return cache[propertyKey][cacheKey];
                }
                const returnValuePromise = originalMethod.apply(this, args);
                if (!(returnValuePromise instanceof Promise)) {
                    throw new Error(`cachedOperation methods must return Promise instance. But ${JSON.stringify(returnValuePromise)} given.`);
                }
                const result = yield returnValuePromise;
                cache[propertyKey][cacheKey] = result;
                return result;
            });
        };
    };
}
exports.cachedOperation = cachedOperation;
function cacheInvalidating(keysCallback, invalidateByKeyStart = false) {
    return function (_target, _propertyKey, descriptor) {
        const originalMethod = descriptor.value;
        descriptor.value = function (...args) {
            return __awaiter(this, void 0, void 0, function* () {
                const invalidateCacheKeys = keysCallback(this, ...args);
                const returnValuePromise = originalMethod.apply(this, args);
                if (!(returnValuePromise instanceof Promise)) {
                    throw new Error(`cacheInvalidating methods must return Promise instance. But ${JSON.stringify(returnValuePromise)} given.`);
                }
                const result = yield returnValuePromise;
                for (const methodName in cache) {
                    if (invalidateByKeyStart) {
                        const cacheKeys = Object.keys(cache[methodName]);
                        for (const cacheKey of cacheKeys) {
                            if (lodash_1.default.some(invalidateCacheKeys, (invalidateCacheKey) => cacheKey.startsWith(invalidateCacheKey))) {
                                delete cache[methodName][cacheKey];
                            }
                        }
                    }
                    else {
                        for (const invalidateCacheKey of invalidateCacheKeys) {
                            delete cache[methodName][invalidateCacheKey];
                        }
                    }
                }
                return result;
            });
        };
    };
}
exports.cacheInvalidating = cacheInvalidating;
//# sourceMappingURL=methodCache.js.map