"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const debugDecorator_1 = require("@signageos/lib/dist/Debug/debugDecorator");
const IBrowser_1 = require("../NativeDevice/IBrowser");
const iframeHelper_1 = require("./iframeHelper");
const DEBUG_NAMESPACE = '@signageos/front-display:Browser:WindowBrowser';
var InternalEvent;
(function (InternalEvent) {
    InternalEvent["WindowOpened"] = "window_opened";
})(InternalEvent || (InternalEvent = {}));
/**
 * Implements Browser API via opening a new browser window
 */
class WindowBrowser {
    constructor(window) {
        this.openedWindow = null;
        this.events = new events_1.EventEmitter();
        this.internalEvents = new events_1.EventEmitter();
        this.window = window;
    }
    addListener(type, cb) {
        this.events.addListener(type, cb);
    }
    removeListener(type, cb) {
        this.events.removeListener(type, cb);
    }
    open(uri, options) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function* () {
            if ((options === null || options === void 0 ? void 0 : options.aclMode) && !(0, iframeHelper_1.isUrlAllowed)(uri, options.aclMode, (_b = (_a = options.aclDomains) === null || _a === void 0 ? void 0 : _a.map((v) => v.toLowerCase())) !== null && _b !== void 0 ? _b : [])) {
                throw new Error(`Default URL of browser ${uri} is not allowed.`);
            }
            if (this.openedWindow) {
                this.openedWindow.close();
            }
            this.openedWindow = this.window.open(uri, uri);
            if (this.openedWindow == null) {
                throw new Error(`Failed to open ${uri}`);
            }
            this.openedWindow.addEventListener('load', () => {
                this.internalEvents.emit(InternalEvent.WindowOpened, this.openedWindow);
            });
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.openedWindow) {
                throw new Error("window doesn't exist");
            }
            try {
                this.openedWindow.close();
                this.openedWindow = null;
                this.events.emit(IBrowser_1.EventType.CLOSE, {
                    type: IBrowser_1.EventType.CLOSE,
                    reason: IBrowser_1.CloseReason.API,
                });
            }
            catch (e) {
                throw new Error("window wasn't opened by script");
            }
        });
    }
    onElementCreated(listener) {
        this.internalEvents.on(InternalEvent.WindowOpened, (window) => {
            listener(window.document.body);
        });
    }
    isSupported() {
        return __awaiter(this, void 0, void 0, function* () {
            return true;
        });
    }
}
exports.default = WindowBrowser;
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [typeof (_a = typeof TType !== "undefined" && TType) === "function" ? _a : Object, Function]),
    __metadata("design:returntype", void 0)
], WindowBrowser.prototype, "addListener", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [typeof (_b = typeof TType !== "undefined" && TType) === "function" ? _b : Object, Function]),
    __metadata("design:returntype", void 0)
], WindowBrowser.prototype, "removeListener", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], WindowBrowser.prototype, "open", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], WindowBrowser.prototype, "close", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Function]),
    __metadata("design:returntype", void 0)
], WindowBrowser.prototype, "onElementCreated", null);
//# sourceMappingURL=WindowBrowser.js.map