"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const debugDecorator_1 = require("@signageos/lib/dist/Debug/debugDecorator");
const IBrowser_1 = require("../NativeDevice/IBrowser");
const iframeHelper_1 = require("./iframeHelper");
const DEBUG_NAMESPACE = '@signageos/front-display:Browser:IframeBrowser';
const ACL_BACKUP_CHECK_INTERVAL_MS = 3e3;
var InternalEvent;
(function (InternalEvent) {
    InternalEvent["NewIframe"] = "new_iframe";
})(InternalEvent || (InternalEvent = {}));
/**
 * Implements Browser API via iframes
 */
class IframeBrowser {
    constructor(window) {
        this.window = window;
        this.iframe = null;
        this.aclInterval = null;
        this.events = new events_1.EventEmitter();
        this.internalEvents = new events_1.EventEmitter();
    }
    open(uri, options) {
        var _a, _b, _c;
        return __awaiter(this, void 0, void 0, function* () {
            if ((options === null || options === void 0 ? void 0 : options.aclMode) && !(0, iframeHelper_1.isUrlAllowed)(uri, options.aclMode, (_a = options.aclDomains) !== null && _a !== void 0 ? _a : [])) {
                throw new Error(`Default URL of browser ${uri} is not allowed.`);
            }
            if (this.iframe) {
                this.removeIframe();
            }
            let iframe;
            if (options && options.coordinates) {
                const { x, y, width, height } = options.coordinates;
                iframe = this.createWindowedIframe(uri, x, y, width, height);
            }
            else {
                iframe = this.createFullscreenIframe(uri);
            }
            this.window.document.body.appendChild(iframe);
            this.iframe = iframe;
            this.internalEvents.emit(InternalEvent.NewIframe, this.iframe);
            if (options === null || options === void 0 ? void 0 : options.aclMode) {
                const denyCallback = () => this.open(uri, options);
                (0, iframeHelper_1.forbidUrlChangeByAcl)(iframe, uri, options.aclMode, (_b = options.aclDomains) !== null && _b !== void 0 ? _b : [], denyCallback);
                const aclValidator = (0, iframeHelper_1.createAclValidator)(iframe, options.aclMode, (_c = options.aclDomains) !== null && _c !== void 0 ? _c : [], denyCallback);
                this.aclInterval = setInterval(aclValidator, ACL_BACKUP_CHECK_INTERVAL_MS);
            }
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.iframe) {
                this.removeIframe();
                this.events.emit(IBrowser_1.EventType.CLOSE, {
                    type: IBrowser_1.EventType.CLOSE,
                    reason: IBrowser_1.CloseReason.API,
                });
            }
            if (this.aclInterval) {
                clearInterval(this.aclInterval);
                this.aclInterval = null;
            }
        });
    }
    addListener(eventName, listener) {
        this.events.addListener(eventName, listener);
    }
    removeListener(eventName, listener) {
        this.events.removeListener(eventName, listener);
    }
    onElementCreated(listener) {
        this.internalEvents.on(InternalEvent.NewIframe, listener);
    }
    isSupported() {
        return __awaiter(this, void 0, void 0, function* () {
            return true;
        });
    }
    createFullscreenIframe(uri) {
        const iframe = this.createBaseIframe(uri);
        iframe.style.width = this.window.document.body.clientWidth + 'px';
        iframe.style.height = this.window.document.body.clientHeight + 'px';
        iframe.style.border = '0';
        iframe.style.top = '0';
        iframe.style.left = '0';
        iframe.style.background = '#ffffff';
        return iframe;
    }
    createWindowedIframe(uri, x, y, width, height) {
        const iframe = this.createBaseIframe(uri);
        iframe.style.width = width + 'px';
        iframe.style.height = height + 'px';
        iframe.style.border = '0';
        iframe.style.top = y + 'px';
        iframe.style.left = x + 'px';
        iframe.style.background = '#ffffff';
        return iframe;
    }
    createBaseIframe(uri) {
        const iframe = this.window.document.createElement('iframe');
        iframe.src = uri;
        iframe.style.width = '100vw';
        iframe.style.height = '100vh';
        iframe.style.position = 'absolute';
        iframe.style.border = '0';
        iframe.style.zIndex = '100';
        iframe.style.webkitTransform = 'translateZ(0)';
        iframe.style.transform = 'translateZ(0)';
        iframe.style.background = '#ffffff';
        try {
            iframe.sandbox.value = 'allow-forms allow-scripts allow-same-origin';
        }
        catch (error) {
            console.warn('Cannot set sandbox value of iframe', error);
        }
        return iframe;
    }
    removeIframe() {
        if (!this.iframe) {
            throw new Error("iframe doesn't exist");
        }
        this.window.document.body.removeChild(this.iframe);
        this.iframe = null;
    }
}
exports.default = IframeBrowser;
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], IframeBrowser.prototype, "open", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], IframeBrowser.prototype, "close", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [typeof (_a = typeof TType !== "undefined" && TType) === "function" ? _a : Object, Function]),
    __metadata("design:returntype", void 0)
], IframeBrowser.prototype, "addListener", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [typeof (_b = typeof TType !== "undefined" && TType) === "function" ? _b : Object, Function]),
    __metadata("design:returntype", void 0)
], IframeBrowser.prototype, "removeListener", null);
__decorate([
    (0, debugDecorator_1.debug)(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Function]),
    __metadata("design:returntype", void 0)
], IframeBrowser.prototype, "onElementCreated", null);
//# sourceMappingURL=IframeBrowser.js.map