"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.storeDeviceSession = exports.afterRegistrationDeviceUidAuthentication = exports.fallbackDeviceUidAuthentication = exports.autoDeviceAuthentication = void 0;
const socketActionCreator_1 = require("../Socket/socketActionCreator");
const effects_1 = require("redux-saga/effects");
const authenticationActions_1 = require("@signageos/actions/dist/Authentication/authenticationActions");
const AuthenticationType_1 = __importDefault(require("@signageos/actions/dist/Authentication/AuthenticationType"));
const AuthenticationFailReason_1 = __importDefault(require("@signageos/actions/dist/Authentication/AuthenticationFailReason"));
const socketActions_1 = require("@signageos/actions/dist/Socket/socketActions");
const deviceActions_1 = require("@signageos/actions/dist/Device/deviceActions");
const RegisterFailReason_1 = __importDefault(require("@signageos/actions/dist/Device/RegisterFailReason"));
function* autoDeviceAuthentication(sessionIdKey, getNativeDriver) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(socketActions_1.SocketConnected, function* () {
        try {
            const sessionId = yield getNativeDriver().getSessionId(sessionIdKey);
            if (!sessionId) {
                yield (0, effects_1.put)({
                    type: authenticationActions_1.AuthenticationFailed,
                    reason: AuthenticationFailReason_1.default.MISSING_SESSION,
                });
            }
            else {
                yield putAuthenticateDevice(sessionId, AuthenticationType_1.default.SESSION);
            }
        }
        catch (error) {
            console.error('autoDeviceAuthentication failed', error);
        }
    });
}
exports.autoDeviceAuthentication = autoDeviceAuthentication;
function* fallbackDeviceUidAuthentication(getNativeDriver) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(authenticationActions_1.AuthenticationFailed, function* (action) {
        try {
            const deviceUid = yield getNativeDriver().getDeviceUid();
            if (action.reason === AuthenticationFailReason_1.default.MISSING_SESSION) {
                yield putAuthenticateDevice(deviceUid, AuthenticationType_1.default.DEVICE_UID);
            }
        }
        catch (error) {
            console.error('fallbackDeviceUidAuthentication failed', error);
        }
    });
}
exports.fallbackDeviceUidAuthentication = fallbackDeviceUidAuthentication;
function* afterRegistrationDeviceUidAuthentication(getNativeDriver) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(deviceActions_1.DeviceRegistrationSucceeded, function* () {
        try {
            const deviceUid = yield getNativeDriver().getDeviceUid();
            yield putAuthenticateDevice(deviceUid, AuthenticationType_1.default.DEVICE_UID);
        }
        catch (error) {
            console.error('afterRegistrationDeviceUidAuthentication failed', error);
        }
    });
    yield (0, socketActionCreator_1.bindAndTakeEvery)(deviceActions_1.DeviceRegistrationFailed, function* (action) {
        try {
            if (action.reason === RegisterFailReason_1.default.ALREADY_EXISTS) {
                const deviceUid = yield getNativeDriver().getDeviceUid();
                yield putAuthenticateDevice(deviceUid, AuthenticationType_1.default.DEVICE_UID);
            }
            else {
                console.error('Registration failed', RegisterFailReason_1.default[action.reason]);
            }
        }
        catch (error) {
            console.error('afterRegistrationFailedDeviceUidAuthentication failed', RegisterFailReason_1.default[action.reason]);
        }
    });
}
exports.afterRegistrationDeviceUidAuthentication = afterRegistrationDeviceUidAuthentication;
function* storeDeviceSession(sessionIdKey, getNativeDriver) {
    yield (0, socketActionCreator_1.bindAndTakeEvery)(authenticationActions_1.SessionCreated, function* (action) {
        try {
            yield getNativeDriver().setSessionId(sessionIdKey, action.uid);
            yield (0, effects_1.put)({ type: authenticationActions_1.NewSessionStored });
        }
        catch (error) {
            console.error('storeDeviceSession failed', error);
        }
    });
}
exports.storeDeviceSession = storeDeviceSession;
function putAuthenticateDevice(identity, authenticationType) {
    const action = {
        type: authenticationActions_1.AuthenticateDevice,
        credentials: { identity: identity },
        authenticationType,
    };
    // TODO delete after all servers has fallback to fixed typo in action
    action.autheticationType = action.authenticationType;
    return (0, effects_1.put)(action);
}
//# sourceMappingURL=authenticationSagas.js.map