"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getZipExtractSize = exports.groupDirectoriesByParents = exports.extractZipBlob = exports.extractZipFile = void 0;
const zip_js_1 = __importDefault(require("zip.js"));
const path_1 = require("path");
const lodash_1 = __importDefault(require("lodash"));
const debug_1 = __importDefault(require("debug"));
const deferred_1 = require("@signageos/lib/dist/Promise/deferred");
const debug = (0, debug_1.default)('@signageos/front-display:Archive:extractor');
function extractZipFile(archiveFileUri, ensureDirectory, createFile) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield window.fetch(archiveFileUri);
        const archiveBlob = yield response.blob();
        return yield extractZipBlob(archiveBlob, ensureDirectory, createFile);
    });
}
exports.extractZipFile = extractZipFile;
function extractZipBlob(archiveBlob, ensureDirectory, createFile) {
    return __awaiter(this, void 0, void 0, function* () {
        const { promise, reject } = (0, deferred_1.createDeferred)(true);
        return Promise.race([
            promise,
            (() => __awaiter(this, void 0, void 0, function* () {
                const reader = yield createZipBlobReader(archiveBlob, reject);
                const entries = yield getZipReaderEntries(reader);
                const directories = entries.filter((entry) => entry.directory).map((entry) => entry.filename);
                // Based on dependencies of parent directories, create directories in order, parents first.
                const groupedDirectories = groupDirectoriesByParents(directories);
                const fileEntries = entries.filter((entry) => !entry.directory);
                // Explicit specification of directories in zip file is optional. First try to create defined dirs
                for (const directoryPaths of groupedDirectories) {
                    yield Promise.all(directoryPaths.map((directoryPath) => ensureDirectory(directoryPath)));
                }
                yield Promise.all(fileEntries.map((entry) => __awaiter(this, void 0, void 0, function* () {
                    const blob = yield getZipEntryData(entry);
                    const parentDirectoryPath = path_1.posix.dirname(entry.filename);
                    if (parentDirectoryPath !== '.') {
                        // Explicit specification of directories in zip file is optional. Ensure file dir always before create file
                        yield ensureDirectory(parentDirectoryPath);
                    }
                    yield createFile(entry.filename, blob);
                })));
                reader.close();
            }))(),
        ]);
    });
}
exports.extractZipBlob = extractZipBlob;
function groupDirectoriesByParents(inputDirs) {
    const sortedDirs = [...inputDirs].sort((a, b) => a.split('/').length - b.split('/').length);
    const groupedDirectories = sortedDirs.reduce((groupedDirs, dir) => {
        const parentDir = path_1.posix.dirname(dir);
        const index = groupedDirs.findIndex((oneGroupDirs) => oneGroupDirs.includes(parentDir));
        const defaultOneGroupDirs = [];
        return lodash_1.default.set(groupedDirs, index + 1, lodash_1.default.get(groupedDirs, index + 1, defaultOneGroupDirs).concat(dir));
    }, []);
    return groupedDirectories;
}
exports.groupDirectoriesByParents = groupDirectoriesByParents;
function getZipExtractSize(blobFile) {
    return __awaiter(this, void 0, void 0, function* () {
        const { promise, reject } = (0, deferred_1.createDeferred)(true);
        return Promise.race([
            promise,
            (() => __awaiter(this, void 0, void 0, function* () {
                const reader = yield createZipBlobReader(blobFile, reject);
                const entries = yield getZipReaderEntries(reader);
                const extractSize = entries.reduce((usage, entry) => {
                    return usage + entry.uncompressedSize;
                }, 0);
                reader.close();
                return extractSize;
            }))(),
        ]);
    });
}
exports.getZipExtractSize = getZipExtractSize;
function createZipBlobReader(archiveBlob, onError) {
    return new Promise((resolve) => zip_js_1.default.createReader(new zip_js_1.default.BlobReader(archiveBlob), resolve, onError));
}
function getZipReaderEntries(reader) {
    return new Promise((resolve) => reader.getEntries(resolve));
}
function getZipEntryData(entry) {
    return new Promise((resolve) => {
        entry.getData(new zip_js_1.default.BlobWriter(''), // TODO content-type
        resolve, (current, total) => debug(`Archive extract progress ${current}/${total}`));
    });
}
//# sourceMappingURL=extractor.js.map