"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createApplication = void 0;
const redux_1 = require("redux");
const redux_saga_1 = __importDefault(require("redux-saga"));
const applicationActions_1 = require("./applicationActions");
const events_1 = require("events");
const applicationMiddlewares_1 = require("./applicationMiddlewares");
function initializeRedux(reducer, getSaga, onError = (error) => console.error(error), storeEmitter) {
    var _a;
    const sagaMiddleware = (0, redux_saga_1.default)({ onError });
    const store = (0, redux_1.createStore)(reducer, (0, redux_1.applyMiddleware)(applicationMiddlewares_1.actionEmitterMiddleware, sagaMiddleware, (0, applicationMiddlewares_1.createActionForwardMiddleware)(storeEmitter)));
    if (globalThis.__POSTPONE_SAGA_EXECUTION) {
        (_a = globalThis.__runSagas) !== null && _a !== void 0 ? _a : (globalThis.__runSagas = []);
        globalThis.__runSagas.push(() => void sagaMiddleware.run(() => getSaga(store)));
    }
    else {
        sagaMiddleware.run(() => getSaga(store));
    }
    return store;
}
function createApplication(reducer, getSaga, getNativeDriver, onError) {
    return __awaiter(this, void 0, void 0, function* () {
        const storeEmitter = new events_1.EventEmitter();
        const nativeDriver = getNativeDriver();
        const store = initializeRedux(reducer, getSaga, onError, storeEmitter);
        nativeDriver.start();
        return {
            store,
            storeEmitter,
            onUnload: () => {
                store.dispatch({ type: applicationActions_1.StopApplication });
                nativeDriver.stop();
            },
        };
    });
}
exports.createApplication = createApplication;
//# sourceMappingURL=applicationFactory.js.map