# Front Display
This library contains all the shared code that is common across all platforms (application types).
It includes the business logic necessary for communicating with the `signageOS` platform service.

In addition, it includes the Emulator, an implementation of the display that can be conveniently used for development purposes in modern browsers such as Chrome.

## Developing
```bash
cp -n config/env.\{a\}.json  config/env.development.json # only for the first time
npm run develop
```

:exclamation: There is a known issue where files transpiled to ES5 during the build process are rewritten back to ES6 when using the `npm run develop` command. This issue does not block development with modern ES6-compliant browsers, but you must always verify functionality in the lowest version of the browser that the code targets. To address this, follow these steps:

```bash
# In one terminal window, run:
esbuild --serve=8080 --servedir=dist

# In a second terminal window, rebuild the code:
npm run build
```

Then, check the application in an older browser to ensure compatibility.

## Testing
To run **unit** and **integration** tests in Node.js environment use the following command:
```bash
npm test
```

To run **browser** tests in the Chrome Headless environment use the following command:
```bash
npm run test-browser
```
> By default, the browser tests run in single run mode.
> If you want to monitor changes and develop your code more quickly, use the following command: `npm run test-browser -- --no-single-run`.

The Browser environment only contains a subset of tests that are practical to run in a near-real browser environment (e.g., for using real browser APIs like CacheStorage, IndexedDB, ServiceWorkers, etc.).

Generally, the browser environment is slow and impractical for developing unit tests.
