# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](http://semver.org/spec/v2.0.0.html).

## [14.21.0] - 2025-06-19
### Added
- Screenshot JS API can now receive aHash information if device supports it
- File system wipeout action can now be called from JS API
- Support for encryption Wi-Fi types in connect properties

## [14.20.0] - 2025-05-27
### Added
- Scheduled reboots can now be created on device with JS API methods like `sos.management.power.setScheduledReboot()`

### Fixed
- (internal) Changed context of management driver scripts execution
- Issues with getting organization tags and location from server

## [14.19.0] - 2025-04-30
### Added
- Telemetry for APPLET

## [14.18.4] - 2025-04-11
### Fixed
- (internal) Changed custom scripts to dynamically inject front-applet

## [14.18.3] - 2025-04-09
### Fixed
- Issue when device executes custom script, telemetry isn't sent immediately

## [14.18.2] - 2025-04-04
### Fixed
- Telemetry for Extended Management URL

## [14.18.1] - 2025-04-03
### Fixed
- Issue with detecting active interface network on default device screens

## [14.18.0] - 2025-04-02
### Added
- Support for encrypted config fields in custom scripts

### Fixed
- Issue when executing custom script isn't returning result after already executing once
- Regenerating keyPair on device

## [14.17.0] - 2025-03-28
### Added
- Calculation of aHash or dHash of uploaded screen shot

### Fixed
- Issue with MD5 checksum on old devices (Blob)

## [14.16.4] - 2025-03-21
### Added
- System log for information about changing device policy items

### Fixed
- Issue with provisioning some devices after offline deprovisioning
- Added back support for legacy Custom Scripts, which was accidentally removed in 14.14.0

## [14.16.3] - 2025-03-14
### Fixed
- Opening OSD on applet start
- OSD can now be opened once per 10 seconds. This prevents multiple requests to open OSD in a short time, which may break OSD and calling JS API in OSD.

## [14.16.2] - 2025-03-10
### Fixed
- (internal) Update the StubMemoryFileSystem to match the new IFile interface

## [14.16.1] - 2025-03-07
### Fixed
- Custom Script execution failure includes error message
- Prevent hanging if extracting non-archive file

## [14.16.0] - 2025-03-03
### Added
- Add support for `sos device connect` with sending logs and errors to the local development machine

## [14.15.1] - 2025-02-28
### Fixed
- Polyfill of fetch for NodeJS environments

## [14.15.0] - 2025-02-28
### Added
- New information about the device on the default screen and on the verification screen
- Refreshed icons on the default screen
- Warning about incorrect time when the device reports that the current year is 3 years lower than actual year

### Fixed
- Issue with validating disconnected device when Wifi is available

## [14.14.0] - 2025-02-28
### Added
- Support for archive custom scripts execution

### Fixed
- Issue with taking instant and periodic screenshots

## [14.13.0] - 2025-02-20
### Fixed
- Emulator will no longer crash on old systems and will use webkit filesystem instead automatically

### Added
- Support for encrypted fields in applet configuration

## [14.12.3] - 2025-02-17
### Fixed
- Auto reconnecting (`autoReconnect: boolean`) stream edge cases and race conditions. 1) Some platforms and streams can emit events `error` and `ended` at the same time. This case was fixed. 2) Multiple streams with reconnect enabled is fixed now.

## [14.12.2] - 2025-02-13
### Fixed
- Fix polyfill compilation, it work correctly now in older browsers

## [14.12.1] - 2025-02-11
### Fixed
- Problem with WS after network change

## [14.12.0] - 2025-02-10
### Added
- Support for mdc commands in custom script

## [14.11.1] - 2025-02-10
### Fixed
- (internal) Updated to the latest version of `lib/bundler` to avoid using the current working directory

## [14.11.0] - 2025-01-30
### Added
- Support for sending MDC with subcommands on Tizen `sos.native.mdc.sendOneRaw()`
- (internal) Use the bundler and node polyfill plugin from lib/bundler
- Support for disabling hardware acceleration on the device `sos.management.setHardwareAcceleration()`

### Fixed
- Append weinre script instead of requiring it

## [14.10.0] - 2025-01-15
### Added
- Telemetry `FEATURE_FLAGS` is now reported
- Limitation for setting stream auto reconnect interval on 10,000ms. If value is lower it may break the streams and reconnection.

### Fixed
- P2p sync on Tizen 4.0
- Storage checking interval when saving offline actions
- Duplication issues with `connected` event on streams, it's now called only when the device truly plays the stream

## [14.9.1] - 2024-12-02
### Fixed
- `sos.sync.connect` doesn't fail for p2p-local if called without network
- Fixed a potential catastrophic failure when driver throws an error during telemetry gathering

## [14.9.0] - 2024-11-20
### Added
- Remote desktop session could be replaced by another SetRemoteDesktopSettings action call
- `sos.sync.isMaster` method to check if the device is the master of a sync group
- `sos.sync.onStatus` events contain field `isMaster` that indicates if the device is the master of that sync group

### Fixed
- `sos.osd.showOSD`

## [14.8.0] - 2024-11-08
### Added
- Support for disabling screenshot capturing using DeviceFeatureFlags
- Randomization of initial and second telemetry delay to reduce peak load on the server (including screenshots)

### Fixed
- Improved P2P sync resilience against network issues. Reliability of P2P synchronization heavily depends on being able to deliver all message to all devices in the group, because each device has to hold the state of the entire network and constantly update it. If a device misses a message, it will have an inconsistent state and will not be able to recover from it. This change improves the reliability of the P2P synchronization by adding a mechanism that ensures that all messages are delivered to all devices in the group.

## [14.7.0] - 2024-10-21
### Added
- Acceptance tests now supports timeout for each test

### Fixed
- Computing file hashes in older browsers
- Function `getArchiveInfo` is now correctly invalidated in cache

## [14.6.0] - 2024-09-30
### Added
- Support for display manager, which is used on ChromeOS to control the connected display
- Telemetry `APP_MODULES` is now reported on every app start

### Fixed
- Missing `APP_MODULES` in Device.Settings.Report.Cache

## [14.5.0] - 2024-09-30
### Added
- Support for custom scripts execution on SoC devices as HTML with embedded JS

## [14.4.1] - 2024-09-19
### Fixed
- Longer time for periodical checking timeDiff and networkChanges

## [14.4.0] - 2024-09-13
### Added
- Remote Desktop is no longer experimental
- (internal) Remote desktop no longer responds to experimental action
- Support for new telemetry `APP_MODULES`

### Fixed
- Prevent concurrent Remote Desktop connections
- (internal) Management: Condition backup restart on `Responsibility.POWER`

## [14.3.0] - 2024-09-02
### Added
- Add `IFrontManagementDriver` interface
- Add battery status support for emulator

## [14.2.5] - 2024-08-26
### Fixed
- (internal) Move types and dependencies to the devDependencies

## [14.2.4] - 2024-08-06
### Fixed
- (internal) Fix Gitlab CI jobs disk going out of space because of bug in downloaded dependencies (@swc/core)

## [14.2.3] - 2024-07-30
### Fixed
- `sos.sync.wait` sometimes entered a deadlock, when using `sync-server` engine due to an internal race condition
- Synchronization engine `sync-server` fixed after breaking in 14.0.0

## [14.2.2] - 2024-07-22
### Fixed
- For `remote-desktop` is used different screenshot upload address

## [14.2.1] - 2024-07-09
### Fixed
- Upgraded remote-desktop and events that are allowed to be processed
- Fix "Should get network info" acceptance test

## [14.2.0] - 2024-07-04
### Added
- add extendWindowSosSnippet

## [14.1.3] - 2024-07-04
### Fixed
- remove references to window object

## [14.1.1] - 2024-06-25
### Fixed
- `NotImplementedBrowser` no longer prevents the app from working
- No longer use icanhazip.com

## [14.1.0] - 2024-06-07
### Added
- Support for a new DISPLAY_POWER_ON telemetry event

## [14.0.0] - 2024-04-30
### Changed
- Build emulator with esbuild
### Added
- Custom Scripts management API implementation

### Fixed
- iFrame-based Browser (`sos.browser.open()`) has no longer a random border on some platforms, strictly setting iframe borders to `0` to always fit the screen region properly

## [13.8.0] - 2024-04-17
### Added
- Support for the `rtscts` option for the serial port configuration. This option is used when opening a serial port and determines whether to enable or disable RTS/CTS handshaking.
### Fixed
- Weinre URL customization
- Devices sends a network interfaces information whenever there were any changes

## [13.7.0] - 2024-04-08
### Added
- Support for Native MDC Commands
- Replaced INetworkInterface with NetworkInterfaces from common-types

## [13.6.4] - 2024-04-03
### Fixed
- Improved local applet connecting

## [13.6.3] - 2024-03-18
### Fixed
- Missing implementations of `copyFile`, `moveFile`, `link` for `StubFileSystem` for a testing purposes

## [13.6.2] - 2024-03-14
### Fixed
- Proprietary timer managers no longer start observing storage without `Responsibility.TIMERS`
- Honor `Responsibility.REMOTE_DESKTOP` and `ManagementCapability.REMOTE_DESKTOP`

## [13.6.1] - 2024-03-04
### Fixed
- P2P Synchronizer Factory defaults to `0.0.0.0` IP address if the device is disconnected

## [13.6.0] - 2024-03-04
### Added
- Proprietary timer storage property to `IManagementDriver` & `IFrontDriver`
- `frontSagas` & `managementSagas` now use native driver to initialize proprietary timers storage and resolvers

### Fixed
- ChromeDriver and ChromeHelper removed from the project

## [13.5.0] - 2024-02-22
### Added
- Support for setting extendedManagementUrl through applet API
- Support for setting extendedManagementUrl through device settings
- Support for setting extendedManagementUrl through device policy

## [13.4.0] - 2024-02-08
### Added
- Support for Virtual Private Network

## [13.3.1] - 2024-01-25
### Fixed
- Refactor telemetry to be not dependent on bundledApplet dependency
- Device should send only initial telemetry if telemetry is set to zero
- Never resolving `showOSD()` function called from applet

## [13.3.0] - 2024-01-24
### Added
- Handling of JS SDK's new sos.stream.pause and sos.stream.resume actions

## [13.2.0] - 2024-01-10
### Added
- Add support for keepAppletRunning prop on proprietary timers
- Stream protocol type can be now string too

### Fixed
- Fix leaking tests
- Use proper types from `@signageos/lib` and `@signageos/common-types` for timers and weekdays
- ReconnectStreamPlayer now properly detect tracks_changed event
- IndexedDB FileSystem extracting zip race condition when creating folders

## [13.1.0] - 2023-11-13
### Added
- Support for stream subtitles and audio channels

### Fixed
- Starting applet in offline (when was already downloaded earlier)
- Typo in stream prepare options: `autoReconnectInternal` -> `autoReconnectInterval`

## [13.0.1] - 2023-11-03
### Fixed
- Issues with remote-desktop on some platforms

## [13.0.0] - 2023-10-04
### Changed
- Added `getExtendedManagementUrl` to `IManagementDriver`

### Added
- Extended Management telemetry
- Extended Management policy
- updateExtendedManagementUrl can be disabled with responsibility
- Throttling offline actions, when rate is beyond limit is ignored

## [12.4.1] - 2023-09-11
### Fixed
- Unset proprietary timer using cloud control

### Changed
- Configuration field extendedManagementUrl no longer updates devices management url

## [12.4.0] - 2023-08-24
### Added
- Remote Desktop support (Over management capability)
- Code coverage reporting
- FS mock moved from test directory for use in other projects
- Stream `autoReconnect`, `autoReconnectInterval` options on `prepare()` and `play()` functions
- Moved stream protocol type into options object on `prepare()` and `play()` functions
- Support for capability `FILE_SYSTEM_ARCHIVE_EXTRACT_INFO`

### Fixed
- WiFi strength not throwing error when not connected
- Unable to connect text is replaced by Conncting to server to better reflect the actual state
- Increase server time checker period from 30 seconds to 1 week

## [12.3.0] - 2023-08-01
### Fixed
- Randomly failing download of applet binaries after restart
- Emulator system info OS version works for Firefox
- Emulator screenshots works even for applets (in iframe)
- Emulator screen size returns real inner window size
### Added
- Add hosting operation system to system info

## [12.2.1] - 2023-07-18
### Fixed
- PeerNetwork will timeout broadcasting value to a peer after 10s

## [12.2.0] - 2023-07-17
### Added
- Get and set Auto recovery from FA
- P2P Synchronizer uses TCP instead of UDP (except for network discovery)
- Synchronizer method `cancelWait()`
- Synchronizer emits event `closed`
- Synchronizer type `p2p-local` which replaces deprecated `udp`
- Stream `prepare()` function now supports options
- New file system method `createArchive` for creating zip archive from files

### Fixed
- Unified Peer recovery configuration & telemetry
- Unified Auto recovery configuration & telemetry
- Improved stability of P2P Synchronizer
- Recognize more keys found on Android TV remotes
- Renamed `clearInternalFileSystem()` to `wipeout()` and moved from IManagementDriver to FileSystem for better integration on device with file system

### Deprecated
- Synchronizer type `udp`

## [12.1.2] - 2023-06-01
### Fixed
- Device policy, broken from 11.3.0 - powerActionTimer passed to policy as dependency
- Input issues on some platforms with keyUp listener

## [12.1.1] - 2023-05-05
### Fixed
- New alternative bridge function for delete proprietary timer (keep old one for backward compatibility)

## [12.1.0] - 2023-04-19
### Added
- IPv4 address to Peer info at Peer discovery service
- Applet Management API support for `setProprietaryTimer()` and `getProprietaryTimers()`

### Fixed
- Base URL for `/time` endpoint to configuration server (instead of platform server)
- Calling `close()` on PolymorphicSynchronizer (e.g. during applet refresh) sometimes broke its internal state and caused it to stop working until application restart or reboot.
- Hardware barcode scanner start (propage `scannerId` to native API)
- Remove unused `volume` from proprietary timers management, policy and telemetry
- P2PSynchronizer `joinGroup()` would sometimes not register 1 or 2 devices that are already in the group due to a race condition

## [12.0.1] - 2023-04-03
### Fixed
- Upgrade lib - `locked` decorator works in Node 6 >=
- IndexedDB File System Service Worker caches only related paths

## [12.0.0] - 2023-03-31
### Changed
- Renamed ISynchronizer method `init` to `joinGroup` and changed it to named args
- Renamed ISynchronizer method `setValue` to `broadcastValue`  and changed it to named args

### Added
- Production config
- Minor update only for development purposes
- P2PSynchronizer support of broadcastValue
- Polymorphic synchronizer that can be used for both P2P and server synchronizer

### Fixed
- P2PSynchronizer support of broadcastValue

## [11.4.0] - 2023-03-22
### Added
- Handler for sending info about remote debug to FA
- Handler for refreshing applet from FA

## [11.3.2] - 2023-03-15
### Fixed
- The regex for index_db is compatible with ES5 and works on displays*

## [11.3.1] - 2023-03-14
### Fixed
- Cache related issues with switching versions in emulator
- Downloading files if server blocks HEAD requests
- Emulator prefer IndexedDB File System implementation over Proprietary (webkit FS)

## [11.3.0] - 2023-02-16
### Added
- Missing implementations for device brand info
- Dummy Wifi class implementation

### Fixed
- Time correction is correctly parsed from response
- Succeed actions for PowerActions are send before restarting

## [11.2.0] - 2023-01-24
### Added
- Switchable check that compares device and server time and when differ a lot it prevents socket from connection
- `device` key for opening serial port is not required now

### Fixed
- Correct telemetry and settings types split

## [11.1.0] - 2022-11-29
### Added
- P2PSynchronizer for synchronizing devices peer-to-peer over UDP in local network

## [11.0.0] - 2022-11-25
### Added
- IndexedDB FileSystem implementation for Emulator under query param `?fileSystem=indexed_db` (support all modern browsers)
- Service Worker support for caching resources and IndexedDB FileSystem

### Removed
- AppCache feature from emulator

## [10.0.0] - 2022-11-22
### Added
- Internal event emitter as Redux middleware
- Allow to open OSD with JS-API

### Changed
- Different methods in IManagementDriver replaced by nested ITimeManager
- `FileSystemWithReservedSpace` now correctly works with `IStorageUnit` properties.

### Removed
- `IFileSystem.initialize` is once again implementation specific.
- `IStorageUnit.reservedSpace` is no longer public. See `IStorageUnit.usableSpace`.

### Fixed
- Documented `IStorageUnit` properties.
- `FileSystemWithReservedSpace` now allows ops that would leave no free space.

## [9.23.0] - 2022-10-07
### Added
- Device reports OS version
- Device auto recovery support in native driver, action & telemetry
- New File System with reserved space
- File System method getArchiveSize for returning size of extracted files

### Fixed
- Remove emulator fix for chrome 104+ (because it breaks loading of relative files to index.html of the applet)

## [9.22.0] - 2022-09-14
### Added
- Device reports manufacturer brand

## [9.21.2] - 2022-09-01
### Fixed
- Duplicate functions for getting iframe src for emulator

## [9.21.1] - 2022-09-01
### Fixed
- Emulator issues with iframe and file system on Chrome 104+

## [9.21.0] - 2022-08-26
### Added
- NotImplementedProxy class

## [9.20.0] - 2022-07-20
### Added
- Emulator support for timed peer recovery

## [9.19.0] - 2022-07-14
### Added
- File System Wipeout power action
- In telemetry reports device capabilities FRONT and MANAGEMENT
- Front capability for Front-OSD
- Front-OSD in Applets

## [9.18.0] - 2022-06-22
### Added
- Telemetry for Wifi strength & proxy
- Device peer recovery methods and telemetry for that.

## [9.17.1] - 2022-06-20
### Fixed
- DeviceInfo when wifi is not supported
- Show verification hash when serial number isn't needed to generate device UID
- Unsubscribe internal video events once video stops for any reason, fixing memory leak
- Add CPU, Memory & Proxy applet messages

## [9.17.0] - 2022-05-24
### Added
- Wifi SSID & strength values
- CPU & Memory monitoring methods
- Proxy monitoring methods

### Fixed
- Tizen verification process doesn't stop under certain circumstances

## [9.16.2] - 2022-04-29
### Fixed
- Only Tizen without serial number is not registered to Box

## [9.16.1] - 2022-04-28
### Fixed
- Device without serial number is not registered
- Bundled servlet options

## [9.16.0] - 2022-04-20
### Added
- Polymorphic browser
- Option to disable offline actions logging

### Fixed
- Weinre debug of applet after applet refresh/reload

## [9.15.0] - 2022-03-24
### Added
- Device location and organization tags can be requested from server, saved in property storage and send to applet when requested
- OS Version information (Windows 11 -> 11, WebOS 3.2 -> 3.2, etc)

### Fixed
- (internal) Upgrade typescript to version 4.6

## [9.14.1] - 2022-03-18
### Fixed
- User defined applet preferred over bundled applet when both are set at the same time

## [9.14.0] - 2022-03-08
### Added
- AppletPings, DeviceAlive and actions about rebooting device are logged online/offline
- RemoteControlSetEnabled drivers method can return optional callback
- onStatus method in AppletSyn pass data about connected devices in group to FA

### Fixed
- (internal) Stability improvement

## [9.13.2] - 2022-02-03
### Fixed
- Checking offline action files before uploading
- Telemetry is forced to sent after scheduled reboots are removed

## [9.13.1] - 2022-01-26
### Added
- Saving applet actions to local file, when device is offline and uploading after connection is fixed

## [9.13.0] - 2022-01-12
### Added
- Telemetry data update after succeeded actions or telemetry set

## [9.12.2] - 2021-12-15
### Added
- Test for CRC 32 with problematic files
- Bundled applet to telemetry
- Accept manual time as object from applet

## [9.12.1] - 2021-12-03
### Fixed
- appendFile FS feature tests

## [9.12.0] - 2021-12-02
### Fixed
- Missing detailed error messages for sos js API
### Added
- Connect to a hidden Wi-Fi

## [9.11.1] - 2021-11-30
### Fixed
- Don't require working connection to signageOS server for app upgrade from direct URL

## [9.11.0] - 2021-11-26
### Added
- Management Network disableInterface

### Fixed
- Don't require working connection to signageOS server for firmware upgrade from direct URL

## [9.10.0] - 2021-11-23
### Added
- Allow parametrize bundled applet with configuration

## [9.9.0] - 2021-11-18
### Fixed
- Correctly check PIN before showing OSD

### Added
- File System appendFile method
- Emulator support for crc32 file system checksum

## [9.8.2] - 2021-11-12
### Fixed
- Version 9.8.0 build fix

## [9.8.1] - 2021-11-12
### Fixed
- Iframe browser API for older devices (with webkit)

## [9.8.0] - 2021-11-12
### Added
- Support for CRC32 hashing algorithm
- Building bundled applet with prebuilt subscriptionType

### Fixed
- Bundled servlets not running when the device doesn't have internet

## [9.7.0] - 2021-11-04
### Added
- Headless Browser API
- Renamed ProprietaryBrowser to IframeBrowser
- Added WindowBrowser as a new implementation of Browser API that opens the URL in a new window

### Fixed
- Firmware upgrade

## [9.6.3] - 2021-09-24
### Fixed
- Bind VerificationSucceeded for Open devices - This fix device provision stuck on hash.

## [9.6.2] - 2021-09-09
### Fixed
- Upgrade firmware version

## [9.6.1] - 2021-08-30
### Fixed
- Fixed display off/on behavior when timers are not set

## [9.6.0] - 2021-08-25
### Added
- Optionally frame rate can be set along with resolution if certain platform supports it

### Fixed
- Waiting for staticBaseUrl dependency doesn't block handling messages from iframes
- Correctly report active network interface
- Server is adjusting telemetry intervals in `/configuration/*` API

## [9.5.1] - 2021-07-23
### Fixed
- Actions are internally bound regardless subscription type dependency

## [9.5.0] - 2021-07-22
### Added
- Not implemented barcode class to ease the front display update

### Fixed
- Refactor proprietary timers handling, fixed work with applet when timer is ON and OF correctly enable/disable running applet and handle the display behavior
- Race condition inside reconnect stream which caused it to reconnect even when stream was already stopped
- Sagas losing this when using withCapability

## [9.4.0] - 2021-06-29
### Added
- Applet and offline cache file urls can be shorter when shortAppletFilesUrl flag enabled

### Fixed
- Native timers, when they are set from policy, method from telemetry now return correct timer type

## [9.3.0] - 2021-06-22
### Added
- Last front or management saga errors can be accessed from console, labels to differ sagas in logs

### Fixed
- Fixed potential race condition when generating initial PIN (since 9.2.0)
- Applets now download as expected (since 9.1.0)
- Changes to PIN are reported, in all situations, once again (since 9.2.0)
- Reset the counter only when policy changed
- Date time policy

## [9.2.0] - 2021-06-02
### Added
- PIN management is guarded by `Responsibility.KIOSK`, allowing native app to override FD implementation.

## [9.1.0] - 2021-06-01
### Added
- Listen for when the custom browser closes
- Policy fail counter/action

### Fixed
- Synchronization of current time to server

## [9.0.0] - 2021-05-17
### Added
- Management features are guarded by `Responsibility`, allowing native app to override FD implementations.
- Dynamically set extended management URL (e.g.: Magic Info URL) based on device configuration API

### Changed
- Native drivers must now explicitly provide a Power Action Timer implementation.
- Native drivers must now explicitly state support for volume and brightness reporting.
- Polyfill is exported from all.ts file & recommend to polyfill all (not just fetch)

### Fixed
- Device policy and telemetry action exceptions are displayed with enabled debug only
- Device Policy: Allow enforcing only NTP server *or* only timezone (or both)
- (internal) `npm run test` now works on Windows with Git Bash or similar
- (internal) File system related tests now run on Windows
- Don't enforce previously set devie policies under Open subscription
- Support `APPLET_ENABLE` and `APPLET_DISABLE` scheduled power actions
- (internal) Hotfix `runPeriodicTaskWhile*` which is depending in initial put of subscription type (500ms delay)
- When applet calls `sos.management.network.listInterfaces()`, return first active ethernet interface, not last

## [8.11.0] - 2021-04-30
### Added
- Barcode scanner API
- Added an attributes corresponding with NTP set on webOS in getCurrentTime

### Fixed
- Internal file system acceptance tests no longer require mounted external storage
- Video acceptance tests no longer report failure when playback succeeds despite unsupported capability (4K, video count)
- Set orientation via device policy
- Temporarily disable licensing algorithm due to issues
- Telemetry is limited for platform devices
- All actions are correctly bound

## [8.10.0] - 2021-04-08
### Fixed
- Scheduled power actions
- Improved HTML5 video handling to limit possibility of memory leak

### Added
- Universal Serial Port implementation

## [8.9.1] - 2021-03-29
### Fixed
- Device policy application upgrading
- takeEveryAndBindWhenPlatform blocks fibre
- Device policy scheduled power actions

## [8.9.0] - 2021-03-18
### Added
- Telemetry
- Device Policy

## [8.8.0] - 2021-03-11
### Added
- Reporting firmware type of device (e.g.: rpi, rpi4, benq_sl550 etc.)

## [8.7.0] - 2021-02-23
### Added
- HTMLVideo fallback to muted playback until interaction in window
- Licensing algorithm

### Fixed
- Emulator error massage related to getSupportedResolutions()
- video playback in emulator wont fail on video changed before prepare finished
- update link to documentation when video playback fails in emulator
- missing favicon error during development in local emulator

## [8.6.1] - 2021-02-09
### Fixed
- Prefix HTTP-only socket connection with /http-socket

## [8.6.0] - 2021-02-09
### Added
- Handle the new version of sos.management.network.setManual()
- Handle the new version of sos.management.network.setDHCP()
- Device socket connection can be optionally replaced with REST based API instead of WebSockets

## [8.5.0] - 2021-02-04
### Added
- Handle sos.management.network.listInterfaces() call from applet

## [8.4.2] - 2021-02-02
### Fixed
- network active info returned to applet correctly determines active interface based on which interface has an IP address

## [8.4.0] - 2021-01-25
### Added
- Messages about setting debug applet propagated into applet iframe
- Device notifies about its supported resolutions if this feature is supported

### Fixed
- Change conditions for selecting fetch or node-fetch

## [8.3.2] - 2021-01-19
### Fixed
- Move node-fetch dep from devDependencies to dependencies

## [8.3.1] - 2021-01-14
### Fixed
- Optimized stream play so when calling play on already prepared stream, there wouldn't be a delay and it would be truly instant

## [8.3.0] - 2021-01-13
### Added
- Get firmware type

### Fixed
- Prevent sending some actions from device to server (optimize traffic)

## [8.2.0] - 2021-01-08
### Added
- Download applet files from computer in the local network
- Current screen orientation can be obtained from front-applet
- Stream can be prepared in the background to allow gapless transitions similarly to videos

## [8.1.0] - 2020-12-17
### Added
- Wi-Fi emits "client_connect_rejected" event when a connection was attempted with invalid credentials and failed
- It's possible to provide additional acceptance tests that should run together with the standard suite of tests

## [8.0.0] - 2020-12-16
### Fixed
- Implementation of configuration checker outside the web worker
- ScreenRotationManager accepts an abstract IScreenRotationPropsProvider interface to allow different implementations on different platforms

### Added
- New ScreenRotationPixelPropsProvider which is usable for older browsers where the viewport vh/vw units are not supported

### Changed
- Arguments style using `options` instead of ordered arguments for management & front constructor

## [7.10.0] - 2020-12-03
### Added
- It's possible to query device capabilities for supported screen orientations
- ScreenRotationManager now allows to optionally pick direction of rotation

## [7.9.0] - 2020-11-24
### Added
- Video duration into HTML video tag video player implementation
- Touch events from native devices are forwarded to iFrame

## [7.8.0] - 2020-11-03
### Added
- Active applet version is sent to iFrame
- Proprietary timers decoupled for better reusability
- Added failover to http if https throws exception when configuration is downloading
- Validating self signed signature when downloading configuration

### Fixed
- MAC address of emulator has 48 bits
- Setting of device time and timezone returns success (when platform needs reboot/restart, do it after 1s)

## [7.7.0] - 2020-09-25
### Added
- Serial ports capability

## [7.6.1] - 2020-09-18
### Fixed
- Options sent to prepare were lost in same cases

## [7.6.0] - 2020-09-10
### Added
- Connect and disconnect events for native stream HTML Player
- Reconnecting Stream Player

## [7.5.2] - 2020-09-08
### Fixed
- Even longer deprovisioning timeout before reboot to give the display enough time to delete all cached data and files

## [7.5.1] - 2020-09-07
### Fixed
- Applet reload sometimes caused the applet to freeze instead of reloading it

## [7.5.0] - 2020-09-03
### Fixed
- Emulator persists in browser (Chrome) memory until cookies are deleted
- Open application refresh stuck when internet is reconnected

### Added
- Wi-Fi Access Point capability
- Emit useful Wi-Fi events to applet
- Changed method of INetwork interface getActiveInfo() into listInterfaces() for more fine grained control of network interfaces
- Video orientation LANDSCAPE_FLIPPED

## [7.4.1] - 2020-07-10
### Fixed
- Separate tests for Weinre and native debug toggle on/off into separate acceptance tests
- Separate changing native debug settings and its possible after-effects on platforms, where it triggers reboot so it can be tested in acceptance tests without triggering reboot

## [7.4.0] - 2020-07-02
### Added
- Remote management of multi-file applets (applet packages). Applets originally designed for `Open` users can be used by `Platform` users now as well.
- Browser open link method optionally accepts theme option

### Fixed
- Extracting API for ZIP files which is missing nested directories
- Fixed Video acceptance tests failing on certain platforms unexpectedly
- Possible memory leak in video player when one gapless video is playing in infinite loop

## [7.3.1] - 2020-06-10
### Fixed
- Removed dependency on navigator.onLine for websocket connections management. Navigator.onLine in certain edge cases doesn't provide accurate information if the device can access internet or not.

## [7.3.0] - 2020-05-29
### Added
- Servlet healthcheck which will result in servlet restart when servlet is not responding
- Front applet debug isEnabled API support
- Default PIN code is 0000 until device is connected to internet
- PIN code set/get support for JS management API

### Fixed
- Device registration occasionally failing during first boot
- Make longer and configurable check interval on platform configuration (30s -> 60s)
- Native debug will always do the configuration check interval 30s

## [7.2.0] - 2020-05-04
### Fixed
- Longer deprovisioning timeout before reboot to give the display enought time to delete all cached data and files
- (internal) Refactor and simplify screen rotation manager
- Use smaller resolution videos in acceptance tests that play multiple videos side by side because some platforms struggle to process more than one full HD video at a time
- Added allow-same-origin sandbox directive to the ProprietaryBrowser iframe to allow loading of websites that enforce same origin policy
- When proprietary timers are disabled while the display and content are off, the display and content will be turned on
- add white background to the proprietary browser to prevent black web
- Loading larger files in emulator, especially videos (used different fetch polyfill)
- Reboot device automatically when App or FW upgrade is performed in open management
- Socket reconnecting in offline state
- Socket autoreconnecting improved
- Fix FileSystem in emulator for larger files than 10MB

### Added
- Support for set NTP time from server
- ACL domains support for proprietary browser implementation of open link
- New OSD dark blue design
- OSD manual network settings (ethernet and wifi)

## [7.1.1] - 2020-03-03
### Fixed
- Bug when collecting temperature and battery status on startup (critical when native methods throws error after boot)

## [7.1.0] - 2020-02-28
### Added
- FILE_SYSTEM_LINK capability

### Fixed
- added sandbox to ProprietaryBrowser iframe to prevent hostile JS within iframe affecting parent document
- First start of display when the applet is bundled inside app (Open)
- Open app installed to deprovisioned device
- Video not showing in emulator in Chrome 80

## [7.0.1] - 2020-02-20
### Fixed
- HTML over video (some of the recent changes broke it)

## [7.0.0] - 2020-02-19
### Added
- simulate firmware update on the default application type (emulator)
- Video API acceptance tests
- When acceptance tests are running, mute applet so it doesn't conflict with the tests
- Video API supports video playing in the background with HTML in the foreground
- Video API supports 4K video
- getTimers method in management API
- Method to gracefully stop all running servlets
- New capability to set/get timezone and time
- Handle deprovisioning directly on device
- Emulator returns fake Serial Number
- Emulator returns fake Network informations
- Emulator simulates portrait orientation
- New capability to set/get NTP server
- New capability to listen to proximity sensor events
- New capability to reset basic settings of the device as means of recovery from breaking external changes
- New capability to get information about connected monitors
- Test Frameworks tests are now able to be skipped
- Management get application version in front-applet `sos.management.app.getVersion()`
- Management API for network set manual, set DHCP
- Browser API for opening/closing browser window and optionally specify a whitelist/blacklist of domains.
- Optional videoThumbnailUriTemplate in file properties
- New capability to perform a factory reset of the device
- File system methods copyFile and moveFile allow to optionally overwrite destination path

### Changed
- Moved `getNetworkInfo()` as `network.getActiveInfo()`

### Deprecated
- Open browser in front-applet via method `sos.browser.openLink()`. Replaced by `sos.browser.open()`.

### Fixed
- Upgraded internal libraries (react, typescript etc.)
- Casually not loading of applet after restart app
- Better user information durring register, verify process (including offline page)
- Touch/Click applet in emulator
- readFile works in every case
- (internal): upgrade build tools
- Integration with browser SSSP (problem with babel in Webpack)
- Test Framework now handles errors properly
- Refreshing of open with turned to platform
- Open applet binary html and front applet js can be absolute or url (fix missing / slash in protocol)
- Replaced moment object by Date/timestamp in methods for setting device date and time
- Ping period issue for open and platform
- Updated to most recent sOS codestyle and commands packages, fixed newly created tslint errors
- Emulator better firmware version emulating for chrome/opera/firefox
- Device Audio test fixed
- Device test framework malfunctions and misbehaving fixed
- Applet commands to device (timing commands) for Open builds

## [6.1.0] - 2019-06-10
### Added
- Possibility to manage features using capabilities (little breaking change in capabilities)
- Node.js servlets - scripts or services that can be pushed to the device from the server and run in the background, extending device's capabilities with custom logic, as long as the device supports it
- It's possible now to configure the application build to use a local applet file instead of getting applet timings from the cloud
- signageOS Open - build with an applet bundled inside the package and make the device automatically verify against the owner's organization on the server
- Always save applet and front applet binaries to internal memory to improve performance and stability
- Use proprietary timer if native is not supported

### Fixed
- Fixed removing non-exiting scheduled actions that can be deleted by factory resets
- Invocations from front-applet has much better & descriptive error messages with links to docs
- Stop binding actions on the server that are purely internal to reduce the traffic
- Add missing call of "finalize" callback after screen orientation is changed from applet management
- Switching between multiple applet timings would freeze the second applet

## [6.0.0] - 2019-02-20
### Added
- File System API supports copyFile, writeFile
- Applet DISABLE/ENABLE power actions
- WiFi driver modules
- OSD support

### Changed
- New API for starting management/front processes (containing initialize method)
- fixed name of remoteControl related methods
- change supports method to be capabilities (timers, brightness scheduling)
- renamed appReboot to systemReboot
- Asynchronous frontSupports capabilities

### Removed
- timers holydays settings in native timers

## [5.4.0] - 2019-01-28
### Fixed
- Escape would reload applet only when OSD is open
- Add mock WiFi capability to emulator
- Fixed keyCodes of input device (5.3.0 version has wrong keyCodes propagated to front-applet)

### Added
- File System API supports writeFile (text (string) value only)

## [5.3.0] - 2019-01-22
### Added
- WiFi support
- OSD

## [5.2.0] - 2019-01-16
### Added
- Low level file system support for front applet

### Fixed
- Fix sos.input.onKeyUp event binding (swapped keyCode & keyName property)

## [5.1.0] - 2018-12-28
### Fixed
- Support camera & microphone for android based devices on webview > M63
- Emulator now supports PERSISTENT file system (needs to confirm permission dialog at the first start)

### Added
- Key codes for media buttons on a remote control (play, pause, stop, backward, forward)

## [5.0.3] - 2018-12-11
### Fixed
- When there are multiple applet timings, the next applet is pre-loaded correctly and allows to preload static assets and setup the environment
- Fixed casually socket repeatable disconnecting and reconnecting in some cases of network state mainly on android devices

## [5.0.2] - 2018-11-28
### Fixed
- Various minor fixes

## [5.0.1] - 2018-11-26
### Fixed
- Extended FileSystem tests and unified errors for all platforms

## [5.0.0] - 2018-11-13
### Added
- New method getNetworkInfo which returns all device network properties
- On verification screen added device local IP Address

### Changed
- New full featured API of FileSystem

### Fixed
- When video play action throws an error in emulator in Chrome, log a warning to console with a link to a documentation page that contains tips for troubleshooting the most common errors

## [4.2.0] - 2018-10-31
### Added
- Redesign verification pages

### Fixed
- Resume video

## [4.1.0] - 2018-09-24
### Fixed
- MD5 checksum will produce correct md5 even for binary files
- Fix not reacting on some monitoring actions from server (temperature, screenshot, battery & storage status, device info)
- Firmware upgrade & screen resize can return finalize callback with reboot instead of just do it after some timeout

### Added
- Removed dependency on Browser-specific features to make it possible to implement management in NodeJS
- It's possible to provide custom implementation of web worker
- It's possible to replace web worker with fake that runs in the same thread
- Moved app upgrade to management driver
- Hash algorithm is now strongly typed and validated against a list of supported algorithms
- File system file names can contain any character except specials (same as Win FS) & can has folders separated by slash /
- ZIP decompression in file system: https://docs.signageos.io/api/sos-applet-api/#Decompress_file_ZIP

## [4.0.0] - 2018-09-12
### Changed
- Socket connections uses new API /v2/ which is not backward compatible

### Added
- Enable applets to get file/content uids
- Enable applets to delete files/contents
- Applets can receive commands from server sent through REST API (applet dispatch command to device)
- Add methods for validating and getting MD5 checksum

### Fixed
- Save applet binary in a different path to avoid collision with files saved by applet
- Device is connected immediatelly. Doesn't matter on server speed
- Weinre debugging is back compatible working with appletEnabled flag

## [3.1.0] - 2018-07-19
### Added
- Schedule power actions
### Fixed
- Switch between applet timings fast and gapless
- Fix tap/double tap touch detection 600 ms delay on every tap
- Fixed playing more videos on devices which supports only 1 video tag (1 resource)

## [3.0.0] - 2018-07-11
### Added
- New communication channel over simple WebSocket as additional for socket.io

### Changed
- Upgrade device firmware with new response API containing only request UID
### Fixed
- Registration of a new device

## [2.3.3] - 2018-06-26
### Fixed
- Downgrade socket.io to 1.7 version

## [2.3.1] - 2018-06-18
### Fixed
- Suspend videos/streams when proprietary timer is triggered

## [2.3.0] - 2018-06-14
### Added
- Option to set video orientation to a different value than the content orientation. It's a workaround for devices that have issues with playing videos in native portrait mode.

### Fixed
- Downgrade to socket.io 1

## [2.2.1] - 2018-06-08
### Fixed
- Not building ES6 source files in Gitlab CI and leaving the old version instead

## [2.2.0] - 2018-06-05
### Added
- Web workers - moved some logic that affected performance the most to web workers so it doesn't run in the same thread (applet timings checking, device configuration change checking)

### Fixed
- Optimized time period for checking of brightness and timers schedules to boost performance

## [2.1.0] - 2018-05-30
### Added
- Remote control Key UP binding

## [2.0.0] - 2018-05-24
### Removed
- Android-specific logic moved to it's own repository
- Tizen-specific logic moved to it's own repository
- SSSP-specific logic moved to it's own repository

## [1.1.1] - 2018-05-16
### Fixed
- Fixed video prepare resolving too early on WebOS, which had an impact on videowall playback
- Allow multiple videos playing simultaneously on Tizen
- Fixed videowall issues with syncing between devices during video playback on Tizen and WebOS

## [1.1.0] - 2018-05-14
### Added
- Changelog file containing all changes in current project
- Testing supported HTML5 features by fast device tests
