"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const debugDecorator_1 = require("@signageos/lib/dist/Debug/debugDecorator");
const IVideoEvent_1 = require("./IVideoEvent");
const AppletVideoError_1 = require("../Error/AppletVideoError");
const ErrorCodes_1 = require("../Error/ErrorCodes");
const ErrorSuggestions_1 = require("../Error/ErrorSuggestions");
const SosError_1 = require("../Error/SosError");
const Validate_1 = require("../Validate/Validate");
const coordinationsHelper_1 = require("../Dimensions/coordinationsHelper");
const DEBUG_NAMESPACE = '@signageos/front-applet:FrontApplet:Video';
class Video {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
        this.onceDeferredIndex = {};
        this.eventEmitter = new events_1.EventEmitter();
    }
    play(uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            this.checkParamsValidity(uri, x, y, width, height);
            ({ x, y, width, height } = coordinationsHelper_1.sanitizeCoordinations({ x, y, width, height }));
            this.removeAllVideoListeners(uri, x, y, width, height); // If not explicitly stopped and played again the same video
            const onceEndedDeferred = this.createOncePromise('ended', uri, x, y, width, height);
            const onceStopDeferred = this.createOncePromise('stop', uri, x, y, width, height);
            yield this.postMessage({
                type: this.getMessage('play'),
                uri,
                x,
                y,
                width,
                height,
            });
            const srcArgumentsString = IVideoEvent_1.stringifySrcArguments(uri, x, y, width, height);
            this.onceDeferredIndex[srcArgumentsString] = {
                ended: onceEndedDeferred,
                stop: onceStopDeferred,
            };
            this.createAndEmitEvent('play', uri, x, y, width, height);
        });
    }
    prepare(uri, x, y, width, height, options = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            this.checkParamsValidity(uri, x, y, width, height);
            ({ x, y, width, height } = coordinationsHelper_1.sanitizeCoordinations({ x, y, width, height }));
            yield this.postMessage({
                type: this.getMessage('prepare'),
                uri,
                x,
                y,
                width,
                height,
                options,
            });
            this.createAndEmitEvent('prepare', uri, x, y, width, height);
        });
    }
    stop(uri, x, y, width, height) {
        var _a, _b, _c;
        return __awaiter(this, void 0, void 0, function* () {
            this.checkParamsValidity(uri, x, y, width, height);
            ({ x, y, width, height } = coordinationsHelper_1.sanitizeCoordinations({ x, y, width, height }));
            yield this.postMessage({
                type: this.getMessage('stop'),
                uri,
                x,
                y,
                width,
                height,
            });
            this.createAndEmitEvent('stop', uri, x, y, width, height);
            const srcArgumentsString = IVideoEvent_1.stringifySrcArguments(uri, x, y, width, height);
            (_c = (_a = this.onceDeferredIndex[srcArgumentsString]) === null || _a === void 0 ? void 0 : (_b = _a.ended).reject) === null || _c === void 0 ? void 0 : _c.call(_b, new AppletVideoError_1.default({
                kind: 'appletVideoError',
                message: `This video was stopped already. The arguments: ${srcArgumentsString}`,
                code: ErrorCodes_1.default.VIDEO_WAS_STOPPED_ALREADY,
                suggestion: ErrorSuggestions_1.default.VIDEO_WAS_STOPPED_ALREADY,
            }));
            delete this.onceDeferredIndex[srcArgumentsString];
        });
    }
    pause(uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            this.checkParamsValidity(uri, x, y, width, height);
            ({ x, y, width, height } = coordinationsHelper_1.sanitizeCoordinations({ x, y, width, height }));
            yield this.postMessage({
                type: this.getMessage('pause'),
                uri,
                x,
                y,
                width,
                height,
            });
            this.createAndEmitEvent('pause', uri, x, y, width, height);
        });
    }
    resume(uri, x, y, width, height) {
        return __awaiter(this, void 0, void 0, function* () {
            this.checkParamsValidity(uri, x, y, width, height);
            ({ x, y, width, height } = coordinationsHelper_1.sanitizeCoordinations({ x, y, width, height }));
            yield this.postMessage({
                type: this.getMessage('resume'),
                uri,
                x,
                y,
                width,
                height,
            });
            this.createAndEmitEvent('resume', uri, x, y, width, height);
        });
    }
    /**
     * Promise is resolved once the currently playing video is ended
     * Promise is rejected when currently playing video is stopped before it's ended (so in case the video will never end)
     */
    onceEnded(uri, x, y, width, height) {
        this.checkParamsValidity(uri, x, y, width, height);
        ({ x, y, width, height } = coordinationsHelper_1.sanitizeCoordinations({ x, y, width, height }));
        const srcArgumentsString = IVideoEvent_1.stringifySrcArguments(uri, x, y, width, height);
        const onceDeferreds = this.onceDeferredIndex[srcArgumentsString];
        if (typeof onceDeferreds === 'undefined') {
            throw new AppletVideoError_1.default({
                kind: 'appletVideoError',
                message: `This video was not played yet. The arguments: ${srcArgumentsString}`,
                code: ErrorCodes_1.default.VIDEO_WAS_NOT_PLAYED_YET,
                suggestion: ErrorSuggestions_1.default.VIDEO_WAS_NOT_PLAYED,
            });
        }
        return onceDeferreds.ended.oncePromise;
    }
    onceStop(uri, x, y, width, height) {
        this.checkParamsValidity(uri, x, y, width, height);
        ({ x, y, width, height } = coordinationsHelper_1.sanitizeCoordinations({ x, y, width, height }));
        const srcArgumentsString = IVideoEvent_1.stringifySrcArguments(uri, x, y, width, height);
        const onceDeferreds = this.onceDeferredIndex[srcArgumentsString];
        if (typeof onceDeferreds === 'undefined') {
            throw new AppletVideoError_1.default({
                kind: 'appletVideoError',
                message: `This video was not played yet. The arguments: ${srcArgumentsString}`,
                code: ErrorCodes_1.default.VIDEO_WAS_NOT_PLAYED_YET,
                suggestion: ErrorSuggestions_1.default.VIDEO_WAS_NOT_PLAYED,
            });
        }
        return onceDeferreds.stop.oncePromise;
    }
    onPlay(listener) {
        Validate_1.default({ listener }).required().function();
        this.eventEmitter.addListener("play", listener);
    }
    onPrepare(listener) {
        Validate_1.default({ listener }).required().function();
        this.eventEmitter.addListener("prepare", listener);
    }
    onStop(listener) {
        Validate_1.default({ listener }).required().function();
        this.eventEmitter.addListener("stop", listener);
    }
    onPause(listener) {
        Validate_1.default({ listener }).required().function();
        this.eventEmitter.addListener("pause", listener);
    }
    onResume(listener) {
        Validate_1.default({ listener }).required().function();
        this.eventEmitter.addListener("resume", listener);
    }
    onEnded(listener) {
        Validate_1.default({ listener }).required().function();
        this.eventEmitter.addListener("ended", listener);
    }
    onError(listener) {
        Validate_1.default({ listener }).required().function();
        this.eventEmitter.addListener("error", listener);
    }
    handleMessageData(data) {
        switch (data.type) {
            case this.getMessage('ended'):
            case this.getMessage('error'):
                const type = data.type.substring(this.getMessage('').length);
                this.createAndEmitEvent(type, data.uri, data.x, data.y, data.width, data.height);
                break;
            default:
        }
    }
    removeEventListeners() {
        this.eventEmitter.removeAllListeners();
    }
    createOncePromise(listenType, uri, x, y, width, height) {
        const deferred = {};
        deferred.oncePromise = new Promise((resolve, reject) => {
            deferred.reject = reject;
            const srcArguments = { uri, x, y, width, height };
            const listenEventName = IVideoEvent_1.getEventName({ type: listenType, srcArguments });
            const errorEventName = IVideoEvent_1.getEventName({ type: 'error', srcArguments });
            const listener = (event) => {
                if (JSON.stringify(event.srcArguments) === JSON.stringify({ uri, x, y, width, height })) {
                    this.eventEmitter.removeListener(listenEventName, listener);
                    this.eventEmitter.removeListener(errorEventName, listener);
                    if (event.type === listenType) {
                        resolve();
                    }
                    else if (event.type === 'error') {
                        reject(new SosError_1.default({
                            kind: 'sosError',
                            message: JSON.stringify(event.srcArguments),
                            code: ErrorCodes_1.default.UNEXPECTED_EXCEPTION,
                        }));
                    }
                }
            };
            this.eventEmitter.addListener(listenEventName, listener);
            this.eventEmitter.addListener(errorEventName, listener);
        });
        return deferred;
    }
    getMessage(name) {
        return this.messagePrefix + '.' + Video.MESSAGE_PREFIX + '.' + name;
    }
    removeAllVideoListeners(uri, x, y, width, height) {
        for (const type of IVideoEvent_1.VIDEO_EVENT_TYPES) {
            const eventName = IVideoEvent_1.getEventName({ type, srcArguments: { uri, x, y, width, height } });
            this.eventEmitter.removeAllListeners(eventName);
        }
    }
    createAndEmitEvent(type, uri, x, y, width, height) {
        const videoEvent = {
            type,
            srcArguments: {
                uri,
                x,
                y,
                width,
                height,
            },
        };
        const eventName = IVideoEvent_1.getEventName(videoEvent);
        this.eventEmitter.emit(eventName, videoEvent);
        this.eventEmitter.emit(videoEvent.type, videoEvent);
    }
    checkParamsValidity(uri, x, y, width, height) {
        Validate_1.default({ uri }).required().uri();
        Validate_1.default({ x }).required().number();
        Validate_1.default({ y }).required().number();
        Validate_1.default({ width }).required().number();
        Validate_1.default({ height }).required().number();
    }
}
Video.MESSAGE_PREFIX = 'video';
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], Video.prototype, "play", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number, Object]),
    __metadata("design:returntype", Promise)
], Video.prototype, "prepare", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], Video.prototype, "stop", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], Video.prototype, "pause", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number]),
    __metadata("design:returntype", Promise)
], Video.prototype, "resume", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number]),
    __metadata("design:returntype", void 0)
], Video.prototype, "onceEnded", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Number, Number, Number, Number]),
    __metadata("design:returntype", void 0)
], Video.prototype, "onceStop", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Function]),
    __metadata("design:returntype", void 0)
], Video.prototype, "onPlay", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Function]),
    __metadata("design:returntype", void 0)
], Video.prototype, "onPrepare", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Function]),
    __metadata("design:returntype", void 0)
], Video.prototype, "onStop", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Function]),
    __metadata("design:returntype", void 0)
], Video.prototype, "onPause", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Function]),
    __metadata("design:returntype", void 0)
], Video.prototype, "onResume", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Function]),
    __metadata("design:returntype", void 0)
], Video.prototype, "onEnded", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Function]),
    __metadata("design:returntype", void 0)
], Video.prototype, "onError", null);
__decorate([
    debugDecorator_1.debug(DEBUG_NAMESPACE),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], Video.prototype, "removeEventListeners", null);
exports.default = Video;
//# sourceMappingURL=Video.js.map