import IPostMessage from '../IPostMessage';
import { BroadcastedValueMessage, ClosedMessage, StatusMessage } from './syncMessages';
import { StatusEvent } from "./syncEvents";
export declare enum SyncEngine {
    SyncServer = "sync-server",
    P2PLocal = "p2p-local",
    /** @deprecated use P2PLocal */
    Udp = "udp"
}
export interface ConnectSyncServerOptions {
    engine?: SyncEngine.SyncServer;
    uri?: string;
}
export interface ConnectP2PLocalOptions {
    engine: SyncEngine.P2PLocal;
}
/** @deprecated use SyncEngine.P2PLocal and ConnectP2PLocalOptions */
export interface ConnectUdpOptions {
    engine: SyncEngine.Udp;
}
export default class Sync {
    private messagePrefix;
    private postMessage;
    static MESSAGE_PREFIX: string;
    private static DEFAULT_GROUP_NAME;
    private eventEmitter;
    constructor(messagePrefix: string, postMessage: IPostMessage<any>);
    connect(options?: string | ConnectSyncServerOptions | ConnectP2PLocalOptions | ConnectUdpOptions): Promise<void>;
    close(): Promise<void>;
    /** @deprecated use joinGroup */
    init(groupName?: string, deviceIdentification?: string): Promise<void>;
    joinGroup({ groupName, deviceIdentification }: {
        groupName?: string;
        deviceIdentification?: string;
    }): Promise<void>;
    leaveGroup(groupName?: string): Promise<void>;
    wait(data?: any, groupName?: string, timeout?: number): Promise<any>;
    cancelWait(groupName?: string): Promise<void>;
    /** @deprecated use broadcastValue */
    setValue(key: string, value: any, groupName?: string): Promise<void>;
    broadcastValue({ groupName, key, value }: {
        groupName?: string;
        key: string;
        value: any;
    }): Promise<void>;
    onValue(listener: (key: string, value: any, groupName?: string) => void): void;
    onStatus(listener: (status: StatusEvent) => void): void;
    onClosed(listener: (error?: Error) => void): void;
    handleMessageData(data: BroadcastedValueMessage | StatusMessage | ClosedMessage): void;
    removeEventListeners(): void;
    private getMessage;
}
