/// <reference types="node" />
import { EventEmitter } from 'events';
import IMessage from '../IMessage';
export interface IStateChangeMessage extends IMessage {
    detected: boolean;
}
export default class Proximity {
    private messagePrefix;
    static MESSAGE_PREFIX: string;
    private eventEmitter;
    private lastDetected;
    constructor(messagePrefix: string);
    onStateChange(callback: (detected: boolean) => void): () => EventEmitter;
    handleMessageData(data: IStateChangeMessage): void;
    private getMessage;
}
