"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Cache_1 = require("./Cache/Cache");
const Types_1 = require("./Types");
const AppendFlagController_1 = require("./Flags/AppendFlagController");
const ISaveFile_1 = require("./ISaveFile");
const JavascriptLoadFileController_1 = require("./LoadFile/JavascriptLoadFileController");
const CssLoadFileController_1 = require("./LoadFile/CssLoadFileController");
const IAddFont_1 = require("./IAddFont");
const fontFaceGenerator_1 = require("../Font/fontFaceGenerator");
const Validate_1 = require("../Validate/Validate");
class Offline {
    constructor(messagePrefix, window, postMessage) {
        this.messagePrefix = messagePrefix;
        this.window = window;
        this.postMessage = postMessage;
        this.FlagControllers = [
            AppendFlagController_1.default,
        ];
        this.LoadFileControllers = [
            JavascriptLoadFileController_1.default,
            CssLoadFileController_1.default,
        ];
        this.cache = new Cache_1.default(this.getMessagePrefix(), this.postMessage);
        this.types = Types_1.default;
        this.loadFile = this.LoadFileControllers.reduce((loadFile, LoadFileController) => {
            const loadFileController = new LoadFileController(this.window);
            loadFile[loadFileController.name] = loadFileController;
            return loadFile;
        }, {});
        this.flagControllers = this.FlagControllers.reduce((flagControllers, FlagController) => {
            const flagController = new FlagController(this.loadFile);
            flagControllers[flagController.name] = flagController;
            return flagControllers;
        }, {});
        this.flags = Object.keys(this.flagControllers).reduce((flags, flagControllerName) => {
            const flagController = this.flagControllers[flagControllerName];
            flags[flagController.name] = (...args) => flagController.create(...args);
            return flags;
        }, {
            append: null,
        });
    }
    addFiles(addFiles) {
        Validate_1.default({ addFiles }).required().array('object');
        const promises = addFiles.map((addFile) => this.addFile(addFile));
        return Promise.all(promises);
    }
    addFilesSync(addFiles) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ addFiles }).required().array('object');
            for (let file of addFiles) {
                yield this.addFile(file);
            }
        });
    }
    addFile(addFile) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ addFile }).required().object(ISaveFile_1.VISaveFile);
            const savedFile = yield this.cache.loadOrSaveFile(addFile.uid, addFile.uri, addFile.headers);
            const flags = addFile.flags || [];
            for (let flag of flags) {
                yield this.handleFileFlag(flag, savedFile, addFile.type);
            }
        });
    }
    addFont(addFont) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ addFont }).required().object(IAddFont_1.VIAddFont);
            const fontGenerator = fontFaceGenerator_1.fontFaceGenerator(this.window, addFont);
            const downloadingFonts = Object.keys(addFont.formats).map((fontExtension) => __awaiter(this, void 0, void 0, function* () {
                const file = yield this.cache.loadOrSaveFile(fontFaceGenerator_1.generateFontUid(addFont.uid, fontExtension), addFont.formats[fontExtension]);
                fontGenerator.setFormat(fontExtension, file.filePath);
            }));
            yield Promise.all(downloadingFonts);
            const styleElement = fontGenerator.generateStyleElement();
            addFont.append.appendChild(styleElement);
        });
    }
    handleFileFlag(flag, file, fileType) {
        return __awaiter(this, void 0, void 0, function* () {
            const flagController = this.flagControllers[flag.type];
            if (typeof flagController === 'undefined') {
                throw new Error('Not implemented apply flag ' + flag.type);
            }
            const filePath = file.filePath;
            yield flagController.applyFlag(flag, fileType, filePath);
        });
    }
    getMessagePrefix() {
        return this.messagePrefix + '.' + Offline.MESSAGE_PREFIX;
    }
}
exports.default = Offline;
Offline.MESSAGE_PREFIX = 'offline';
//# sourceMappingURL=Offline.js.map