import IFileType from './IFileType';
import IFlag from './Flags/IFlag';
import ErrorCodes from "../Error/ErrorCodes";
export default ISaveFile;
interface ISaveFile {
    uid: string;
    uri: string;
    type: IFileType;
    headers?: {
        [key: string]: string;
    };
    flags?: IFlag[];
}
export declare const VISaveFile: {
    uid: {
        string: null;
        error: {
            code: ErrorCodes;
            message: string;
        };
    };
    uri: string;
    type: {
        string: string[];
        error: {
            code: ErrorCodes;
            message: string;
        };
    };
    headers: string;
    flags: {
        '?array': {
            object: {
                type: {
                    string: string[];
                };
                element: {
                    object: {
                        uid: string;
                    };
                };
            };
            error: {
                code: ErrorCodes;
                message: string;
            };
        };
    };
};
