"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const generator_1 = require("../../Hash/generator");
class AppendFlagController {
    constructor(loadFile) {
        this.loadFile = loadFile;
        this.name = 'append';
        this.elementCache = {};
    }
    create(element) {
        const uid = generator_1.generateUniqueHash();
        this.elementCache[uid] = element;
        return {
            type: "append",
            element: {
                uid,
            },
        };
    }
    applyFlag(flag, fileType, filePath) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof flag.element !== 'object') {
                throw new Error('File flag of type "append" needs to be object');
            }
            const element = this.elementCache[flag.element.uid];
            if (typeof element === 'undefined') {
                throw new Error('File flag element for "append" not found');
            }
            const loadFileController = this.loadFile[fileType];
            if (typeof loadFileController === 'undefined') {
                throw new Error('File of type "' + fileType + '" cannot be appent');
            }
            yield loadFileController.load(filePath, element);
        });
    }
}
exports.default = AppendFlagController;
//# sourceMappingURL=AppendFlagController.js.map