import IPostMessage from '../../IPostMessage';
import IFile from './IFile';
import ISavedFileMessage from './ISavedFileMessage';
import ISavedContentMessage from './ISavedContentMessage';
import ILoadedFileMessage from './ILoadedFileMessage';
import ILoadedContentMessage from './ILoadedContentMessage';
import IListedFilesMessage from './IListedFilesMessage';
import IListedContentsMessage from './IListedContentsMessage';
import IValidatedChecksumMessage from "./IValidatedChecksumMessage";
import IChecksumMessage from "./IChecksumMessage";
export default class Cache {
    private messagePrefix;
    private postMessage;
    static MESSAGE_PREFIX: string;
    private savedFiles;
    private savedContents;
    constructor(messagePrefix: string, postMessage: IPostMessage<ISavedFileMessage & ISavedContentMessage & ILoadedFileMessage & ILoadedContentMessage & IListedFilesMessage & IListedContentsMessage & IChecksumMessage & IValidatedChecksumMessage>);
    listFiles(): Promise<string[]>;
    loadFile(uid: string): Promise<IFile>;
    saveFile(uid: string, uri: string, headers?: {
        [key: string]: string;
    }): Promise<void>;
    loadOrSaveFile(uid: string, uri: string, headers?: {
        [key: string]: string;
    }): Promise<IFile>;
    deleteFile(uid: string): Promise<void>;
    listContents(): Promise<string[]>;
    loadContent(uid: string): Promise<string>;
    saveContent(uid: string, content: string): Promise<void>;
    deleteContent(uid: string): Promise<void>;
    validateChecksumFile(uid: string, hash: string, hashType: string): Promise<boolean>;
    getChecksumFile(uid: string, hashType: string): Promise<string>;
    decompressFile(uid: string, destinationUid: string, method: 'zip'): Promise<void>;
    private getCachedFile;
    private getMessage;
    private checkUidValidity;
    private isHeaders;
}
