"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseUpgradeArguments = void 0;
const url = require("url");
function parseUpgradeArguments(arg1, arg2) {
    let baseUrl;
    let version;
    let directUri;
    if (isUrl(arg1) && arg2 && !isUrl(arg2)) {
        baseUrl = arg1;
        version = arg2;
    }
    else if (!isUrl(arg1) && arg2 && isUrl(arg2)) {
        baseUrl = arg2;
        version = arg1;
    }
    else if (isUrl(arg1) && !arg2) {
        directUri = arg1;
    }
    else if (!isUrl(arg1) && !arg2) {
        version = arg1;
    }
    else {
        throw new Error(`Invalid arguments. See JSDoc for details`);
    }
    return {
        baseUrl,
        version,
        directUri,
    };
}
exports.parseUpgradeArguments = parseUpgradeArguments;
function isUrl(arg1) {
    return !!url.parse(arg1).hostname;
}
//# sourceMappingURL=UpgradeHelper.js.map