"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VIWifiConnectOptions = void 0;
const events_1 = require("events");
const IWifiEvent_1 = require("./IWifiEvent");
const Validate_1 = require("../Validate/Validate");
exports.VIWifiConnectOptions = {
    hidden: '?boolean',
};
class Wifi {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
        this.eventEmitter = new events_1.EventEmitter();
    }
    isClientEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            const { isWifiEnabled } = yield this.postMessage({
                type: this.getMessage('is_enabled'),
            });
            return isWifiEnabled;
        });
    }
    enableClient() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('enable'),
            });
        });
    }
    isAPEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            const { isWifiAPEnabled } = yield this.postMessage({
                type: this.getMessage('is_ap_enabled'),
            });
            return isWifiAPEnabled;
        });
    }
    enableAP(ssid, password) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ ssid }).required().string();
            Validate_1.default({ password }).required().string();
            yield this.postMessage({
                type: this.getMessage('enable_ap'),
                ssid,
                password,
            });
        });
    }
    disable() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('disable'),
            });
        });
    }
    getConnectedTo() {
        return __awaiter(this, void 0, void 0, function* () {
            const wifiDevice = yield this.postMessage({
                type: this.getMessage('get_connected_to'),
            });
            return wifiDevice || null;
        });
    }
    /**
     * Connect to a Wi-Fi network
     * @param ssid
     * @param password
     * @param options
     */
    connect(ssid, password, options = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ ssid }).required().string();
            Validate_1.default({ password }).string();
            Validate_1.default({ options }).object(exports.VIWifiConnectOptions);
            yield this.postMessage({
                type: this.getMessage('connect'),
                ssid,
                password,
                options,
            });
        });
    }
    disconnect() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('disconnect'),
            });
        });
    }
    getCountry() {
        return __awaiter(this, void 0, void 0, function* () {
            const { countryCode } = yield this.postMessage({
                type: this.getMessage('get_country'),
            });
            return countryCode || null;
        });
    }
    setCountry(countryCode) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ countryCode }).required().string();
            yield this.postMessage({
                type: this.getMessage('set_country'),
                countryCode,
            });
        });
    }
    scanDevices() {
        return __awaiter(this, void 0, void 0, function* () {
            const { devices } = yield this.postMessage({
                type: this.getMessage('scan'),
            });
            return devices;
        });
    }
    on(event, listener) {
        this.eventEmitter.on(event, listener);
    }
    once(event, listener) {
        this.eventEmitter.once(event, listener);
    }
    removeListener(event, listener) {
        this.eventEmitter.removeListener(event, listener);
    }
    removeAllListeners(event) {
        if (event) {
            this.eventEmitter.removeAllListeners(event);
        }
        else {
            this.eventEmitter.removeAllListeners();
        }
    }
    handleMessageData(data) {
        switch (data.type) {
            case this.getMessage('event_' + IWifiEvent_1.WifiEvent.CLIENT_ENABLED):
            case this.getMessage('event_' + IWifiEvent_1.WifiEvent.CLIENT_CONNECTED):
            case this.getMessage('event_' + IWifiEvent_1.WifiEvent.CLIENT_CONNECT_REJECTED):
            case this.getMessage('event_' + IWifiEvent_1.WifiEvent.CLIENT_DISCONNECTED):
            case this.getMessage('event_' + IWifiEvent_1.WifiEvent.AP_ENABLED):
            case this.getMessage('event_' + IWifiEvent_1.WifiEvent.DISABLED):
                const typeStringWithoutEvent = this.getMessage('event_');
                const event = data.type.substring(typeStringWithoutEvent.length);
                this.eventEmitter.emit(event);
                break;
            default:
        }
    }
    getMessage(name) {
        return this.messagePrefix + '.' + Wifi.MESSAGE_PREFIX + '.' + name;
    }
}
exports.default = Wifi;
Wifi.MESSAGE_PREFIX = 'wifi';
//# sourceMappingURL=Wifi.js.map