"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Validate_1 = require("../Validate/Validate");
const VDateTime = {
    year: 'number',
    month: 'number',
    day: 'number',
    hour: 'number',
    minute: 'number',
    second: 'number',
};
class Time {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    get() {
        return __awaiter(this, void 0, void 0, function* () {
            const { currentTimeWithTimezone } = yield this.postMessage({
                type: this.getMessage('get_current_time_with_timezone'),
            });
            return currentTimeWithTimezone;
        });
    }
    /** @deprecated use setManual instead */
    set(currentDate, timezone) {
        return this.setManual(currentDate, timezone);
    }
    setManual(...args) {
        return __awaiter(this, void 0, void 0, function* () {
            const [currentDate, timezone] = args;
            if (currentDate instanceof Date) {
                Validate_1.default({ currentDate }).required().date();
            }
            else {
                Validate_1.default({ currentDate }).required().object(VDateTime);
            }
            Validate_1.default({ timezone }).required().string();
            yield this.postMessage({
                type: this.getMessage('set_current_time_with_timezone'),
                currentDate,
                timezone,
            });
        });
    }
    setNTP(ntpServer, timezone) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ ntpServer }).required().string();
            Validate_1.default({ timezone }).required().string();
            yield this.postMessage({
                type: this.getMessage('set_ntp_time_with_timezone'),
                ntpServer,
                timezone,
            });
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + name;
    }
}
exports.default = Time;
//# sourceMappingURL=Time.js.map