import IPostMessage from '../IPostMessage';
/**
 * All values are raw, none are zero-indexed.
 */
export interface DateTime {
    year: number;
    month: number;
    day: number;
    hour: number;
    minute: number;
    second: number;
}
export default class Time {
    private messagePrefix;
    private postMessage;
    constructor(messagePrefix: string, postMessage: IPostMessage<any>);
    get(): Promise<{
        currentDate: Date;
        timezone?: string;
        ntpServer?: string;
    }>;
    /** @deprecated use setManual instead */
    set(currentDate: Date, timezone: string): Promise<void>;
    /** @deprecated use setManual, where first argument is DateTime object */
    setManual(currentDate: Date, timezone: string): Promise<void>;
    /**
     * Set manual datetime and timezone
     * @param dateTime
     * @param timezone
     */
    setManual(dateTime: DateTime, timezone: string): Promise<void>;
    setNTP(ntpServer: string, timezone: string): Promise<void>;
    private getMessage;
}
