"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
class Proxy {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    isEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            const { isEnabled } = yield this.postMessage({
                type: this.getMessage('proxy_is_enabled'),
            });
            return isEnabled;
        });
    }
    setManual(uri, port, username, password) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('proxy_set_manual'),
                uri,
                port,
                username,
                password,
            });
        });
    }
    disable() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('proxy_disable'),
            });
        });
    }
    getConnectedTo() {
        return __awaiter(this, void 0, void 0, function* () {
            const { connectedTo } = yield this.postMessage({
                type: this.getMessage('proxy_get_connected_to'),
            });
            return connectedTo;
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + name;
    }
}
exports.default = Proxy;
//# sourceMappingURL=Proxy.js.map