"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const IPeerRecovery_1 = require("./IPeerRecovery");
class PeerRecovery {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    get() {
        return __awaiter(this, void 0, void 0, function* () {
            const settings = yield this.postMessage({ type: this.getMessage("get_peer_recovery") });
            return settings;
        });
    }
    set(configuration) {
        return __awaiter(this, void 0, void 0, function* () {
            IPeerRecovery_1.validatePeerRecoveryConfiguration(configuration);
            yield this.postMessage(Object.assign({ type: this.getMessage("set_peer_recovery") }, configuration));
        });
    }
    getMessage(name) {
        return this.messagePrefix + "." + name;
    }
}
exports.default = PeerRecovery;
//# sourceMappingURL=PeerRecovery.js.map