"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Validate_1 = require("../Validate/Validate");
class Package {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    install(baseUrl, packageName, version, build) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ baseUrl }).required().uri();
            Validate_1.default({ packageName }).required().string();
            Validate_1.default({ version }).required().string();
            Validate_1.default({ build }).canBeNull().required().string();
            yield this.postMessage({
                type: this.getMessage('install_package'),
                baseUrl,
                packageName,
                version,
                build,
            });
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + name;
    }
}
exports.default = Package;
//# sourceMappingURL=Package.js.map