"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const INetworkInfo_1 = require("./INetworkInfo");
const Validate_1 = require("../Validate/Validate");
class Network {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    /** @deprecated use sos.management.network.listInterfaces() instead */
    getActiveInfo() {
        return __awaiter(this, void 0, void 0, function* () {
            const { networkInfo } = yield this.postMessage({
                type: this.getMessage('get_network_info'),
            });
            return networkInfo;
        });
    }
    listInterfaces() {
        return __awaiter(this, void 0, void 0, function* () {
            const { interfaces } = yield this.postMessage({
                type: this.getMessage('get_network_interfaces'),
            });
            return interfaces;
        });
    }
    setManual(...args) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof args[0] === 'string') {
                const [interfaceName, options] = args;
                Validate_1.default({ interfaceName }).required().string();
                Validate_1.default({ options }).required().object(INetworkInfo_1.VINetworkOptions);
                yield this.postMessage({
                    type: this.getMessage('set_network_manual_v2'),
                    interfaceName,
                    options,
                });
            }
            else {
                const [options] = args;
                Validate_1.default({ options }).required().object(INetworkInfo_1.VINetworkOptionsLegacy);
                yield this.postMessage({
                    type: this.getMessage('set_network_manual'),
                    options,
                });
            }
        });
    }
    setDHCP(...args) {
        return __awaiter(this, void 0, void 0, function* () {
            if (args[0] === 'ethernet' || args[0] === 'wifi') {
                const [networkInterface] = args;
                Validate_1.default({ networkInterface }).required().string(INetworkInfo_1.VNetworkInterface);
                yield this.postMessage({
                    type: this.getMessage('set_network_dhcp'),
                    networkInterface,
                });
            }
            else {
                const [interfaceName] = args;
                Validate_1.default({ interfaceName }).required().string();
                yield this.postMessage({
                    type: this.getMessage('set_network_dhcp_v2'),
                    interfaceName,
                });
            }
        });
    }
    disableInterface(interfaceName) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ interfaceName }).required().string();
            yield this.postMessage({
                type: this.getMessage('disable_network_interface'),
                interfaceName,
            });
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + name;
    }
}
exports.default = Network;
//# sourceMappingURL=Network.js.map