"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Firmware_1 = require("./Firmware");
const Audio_1 = require("./Audio");
const Screen_1 = require("./Screen");
const RemoteControl_1 = require("./RemoteControl");
const Time_1 = require("./Time");
const App_1 = require("./App");
const OS_1 = require("./OS");
const Debug_1 = require("./Debug");
const Package_1 = require("./Package");
const Power_1 = require("./Power");
const Network_1 = require("./Network");
const Wifi_1 = require("./Wifi");
const Security_1 = require("./Security");
const Validate_1 = require("../Validate/Validate");
const Proxy_1 = require("./Proxy");
const PeerRecovery_1 = require("./PeerRecovery");
const AutoRecovery_1 = require("./AutoRecovery");
class Management {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
        this.app = new App_1.default(this.getMessagePrefix(), this.postMessage);
        this.os = new OS_1.default(this.getMessagePrefix(), this.postMessage);
        this.audio = new Audio_1.default(this.getMessagePrefix(), this.postMessage);
        this.debug = new Debug_1.default(this.getMessagePrefix(), this.postMessage);
        this.firmware = new Firmware_1.default(this.getMessagePrefix(), this.postMessage);
        this.package = new Package_1.default(this.getMessagePrefix(), this.postMessage);
        this.power = new Power_1.default(this.getMessagePrefix(), this.postMessage);
        this.remoteControl = new RemoteControl_1.default(this.getMessagePrefix(), this.postMessage);
        this.screen = new Screen_1.default(this.getMessagePrefix(), this.postMessage);
        this.time = new Time_1.default(this.getMessagePrefix(), this.postMessage);
        this.network = new Network_1.default(this.getMessagePrefix(), this.postMessage);
        this.wifi = new Wifi_1.default(this.getMessagePrefix(), this.postMessage);
        this.security = new Security_1.default(this.getMessagePrefix(), this.postMessage);
        this.proxy = new Proxy_1.default(this.getMessagePrefix(), this.postMessage);
        this.autoRecovery = new AutoRecovery_1.default(this.getMessagePrefix(), this.postMessage);
        this.peerRecovery = new PeerRecovery_1.default(this.getMessagePrefix(), this.postMessage);
    }
    supports(capability) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ capability }).required().string();
            const { supports } = yield this.postMessage({
                type: this.getMessage('supports'),
                capability,
            });
            return supports;
        });
    }
    getModel() {
        return __awaiter(this, void 0, void 0, function* () {
            const { model } = yield this.postMessage({
                type: this.getMessage('get_model'),
            });
            return model;
        });
    }
    getSerialNumber() {
        return __awaiter(this, void 0, void 0, function* () {
            const { serialNumber } = yield this.postMessage({
                type: this.getMessage('get_serial_number'),
            });
            return serialNumber;
        });
    }
    /** @deprecated Use sos.management.network.getActiveInfo() instead */
    getNetworkInfo() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.network.getActiveInfo();
        });
    }
    getBatteryStatus() {
        return __awaiter(this, void 0, void 0, function* () {
            const { batteryStatus } = yield this.postMessage({
                type: this.getMessage('get_battery_status'),
            });
            return batteryStatus;
        });
    }
    getTemperature() {
        return __awaiter(this, void 0, void 0, function* () {
            const { currentTemperature } = yield this.postMessage({
                type: this.getMessage('get_current_temperature'),
            });
            return currentTemperature;
        });
    }
    getBrand() {
        return __awaiter(this, void 0, void 0, function* () {
            const { brand } = yield this.postMessage({
                type: this.getMessage('get_brand'),
            });
            return brand;
        });
    }
    resetSettings() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('reset_settings'),
            });
        });
    }
    factoryReset() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('factory_reset'),
            });
        });
    }
    getMessage(name) {
        return this.getMessagePrefix() + '.' + name;
    }
    getMessagePrefix() {
        return this.messagePrefix + '.' + Management.MESSAGE_PREFIX;
    }
}
exports.default = Management;
Management.MESSAGE_PREFIX = 'management';
//# sourceMappingURL=Management.js.map