export declare type NetworkInterface = 'wifi' | 'ethernet';
export declare const VNetworkInterface: string[];
/**
 * @deprecated use INetworkInterface instead
 */
export default interface INetworkInfo {
    localAddress: string;
    ethernetMacAddress: string;
    wifiMacAddress: string;
    activeInterface: NetworkInterface;
    gateway?: string;
    netmask?: string;
    dns?: string[];
    interfaceName?: string;
    /**
     * Number in range from 0 to 100 (percentage)
     * mapped from -90 dBm unusable signal
     * to -30 dBm excellent signal.
     */
    wifiStrength?: number;
    wifiSsid?: string;
}
export interface INetworkInterface {
    type: NetworkInterface;
    name: string;
    macAddress: string;
    localAddress?: string;
    gateway?: string;
    netmask?: string;
    dns?: string[];
    disabled?: boolean;
    /**
     * Number in range from 0 to 100 (percentage)
     * mapped from -90 dBm unusable signal
     * to -30 dBm excellent signal.
     */
    wifiStrength?: number;
    wifiSsid?: string;
}
export interface INetworkOptionsLegacy {
    interface: NetworkInterface;
    localAddress: string;
    gateway: string;
    netmask: string;
    dns: string[];
}
export interface INetworkOptions {
    localAddress: string;
    gateway: string;
    netmask: string;
    dns: string[];
}
export declare const VINetworkOptionsLegacy: {
    interface: {
        string: string[];
    };
    localAddress: string;
    gateway: string;
    netmask: string;
    dns: {
        array: string;
    };
};
export declare const VINetworkOptions: {
    localAddress: string;
    gateway: string;
    netmask: string;
    dns: {
        array: string;
    };
};
export interface IWifiDevice {
    ssid: string;
    strength?: number;
    encrypted?: boolean;
}
