"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateAutoRecoveryConfiguration = void 0;
const Validate_1 = require("../Validate/Validate");
const validateAutoRecoveryConfiguration = (configuration) => {
    const validation = Validate_1.default({ configuration }).setError(new Error('Invalid auto recovery configuration')).required();
    if (!configuration.enabled) {
        validation.object({ enabled: 'boolean', autoEnableTimeoutMs: '?number' });
    }
    else {
        validation.object({ enabled: 'boolean', healthcheckIntervalMs: 'number' });
    }
};
exports.validateAutoRecoveryConfiguration = validateAutoRecoveryConfiguration;
//# sourceMappingURL=IAutoRecovery.js.map