"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const UpgradeHelper_1 = require("./helpers/UpgradeHelper");
class Firmware {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    upgrade(arg1, arg2) {
        return __awaiter(this, void 0, void 0, function* () {
            const { baseUrl, version, directUri } = UpgradeHelper_1.parseUpgradeArguments(arg1, arg2);
            yield this.postMessage({
                type: this.getMessage('firmware_upgrade'),
                baseUrl,
                version,
                directUri,
            });
        });
    }
    getVersion() {
        return __awaiter(this, void 0, void 0, function* () {
            const { firmwareVersion } = yield this.postMessage({
                type: this.getMessage('get_firmware_version'),
            });
            return firmwareVersion;
        });
    }
    getType() {
        return __awaiter(this, void 0, void 0, function* () {
            const { firmwareType } = yield this.postMessage({
                type: this.getMessage('get_firmware_type'),
            });
            return firmwareType;
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + name;
    }
}
exports.default = Firmware;
//# sourceMappingURL=Firmware.js.map