"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Validate_1 = require("../Validate/Validate");
class Audio {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    getVolume() {
        return __awaiter(this, void 0, void 0, function* () {
            const { volume } = yield this.postMessage({
                type: this.getMessage('get_volume'),
            });
            return volume;
        });
    }
    setVolume(volume) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ volume }).required().number().min(0).max(100);
            yield this.postMessage({
                type: this.getMessage('set_volume'),
                volume,
            });
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + name;
    }
}
exports.default = Audio;
//# sourceMappingURL=Audio.js.map