"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class Iframe {
    constructor(window, messagePrefix, base, transformers) {
        this.window = window;
        this.messagePrefix = messagePrefix;
        this.base = base;
        this.transformers = transformers;
        this.frontAppletWindows = [];
    }
    registerFrontAppletLoaderWindow(frontAppletWindow) {
        frontAppletWindow.postMessage({
            type: this.getMessage('api_js_uri'),
            uri: this.base.apiJsUri,
        }, '*');
    }
    registerBundledFrontAppletWindow(frontAppletWindow) {
        this.frontAppletWindows.push(frontAppletWindow);
        frontAppletWindow.postMessage({
            type: this.getMessage('config.update'),
            config: this.base.config,
        }, '*');
        frontAppletWindow.postMessage({
            type: this.getMessage('auth_hash.update'),
            authHash: this.base.authHash,
        }, '*');
        frontAppletWindow.postMessage({
            type: this.getMessage('front_display_version.update'),
            version: this.base.display.version,
        }, '*');
    }
    forwardToFrontAppletWindows(originalData) {
        for (let frontAppletWindow of this.frontAppletWindows) {
            const transformedData = this.transformers.reduce((data, transformer) => data ? transformer(data, frontAppletWindow) : data, originalData);
            if (typeof transformedData === 'undefined') {
                continue;
            }
            frontAppletWindow.postMessage(transformedData, '*');
        }
    }
    forwardFromFrontAppletWindows(frontAppletWindow, data) {
        if (this.frontAppletWindows.indexOf(frontAppletWindow) !== -1) {
            this.window.parent.postMessage(data, '*');
        }
    }
    getMessage(name) {
        return this.messagePrefix + '.' + name;
    }
}
exports.default = Iframe;
//# sourceMappingURL=Iframe.js.map