import Display from '../Display/Display';
/**
 * If some transformer returns undefined, transforming message will not be forwarded to certain target
 * window and next transformers will not be called.
 */
export declare type Transformer = <T>(data: T, target: Window) => T | undefined;
export default class Iframe {
    private window;
    private messagePrefix;
    private base;
    private transformers;
    private frontAppletWindows;
    constructor(window: Window, messagePrefix: string, base: {
        apiJsUri: string;
        config: any | null;
        authHash: string | null;
        display: Display;
    }, transformers: Transformer[]);
    registerFrontAppletLoaderWindow(frontAppletWindow: Window): void;
    registerBundledFrontAppletWindow(frontAppletWindow: Window): void;
    forwardToFrontAppletWindows(originalData: any): void;
    forwardFromFrontAppletWindows(frontAppletWindow: Window, data: any): void;
    private getMessage;
}
