"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
class SerialPort {
    constructor(refid, eventEmitter, messagePrefix, postMessage) {
        this.refid = refid;
        this.eventEmitter = eventEmitter;
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    onData(listener) {
        this.eventEmitter.addListener('serial_port.data.' + this.refid, listener);
    }
    write(data) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('serial_port.write'),
                refid: this.refid,
                data,
            });
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('serial_port.close'),
                refid: this.refid,
            });
            this.eventEmitter.removeAllListeners('serial_port.data.' + this.refid);
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + name;
    }
}
exports.default = SerialPort;
//# sourceMappingURL=SerialPort.js.map