"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const ErrorCodes_1 = require("../../Error/ErrorCodes");
const Validate_1 = require("../../Validate/Validate");
class Led {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    setColor(color) {
        return __awaiter(this, void 0, void 0, function* () {
            this.checkColorValidity(color);
            yield this.postMessage({
                type: this.getMessage('set_color'),
                color: color ? color.toUpperCase() : null,
            });
        });
    }
    checkColorValidity(color) {
        Validate_1.default({ color }).canBeNull().string(null, ErrorCodes_1.default.HARDWARE_LED_COLOR_IS_NOT_STRING);
        Validate_1.default({ color }).canBeNull().matchRegExp(/^#[0-9A-Fa-f]{6,6}$/, ErrorCodes_1.default.HARDWARE_LED_COLOR_IS_NOT_VALID);
    }
    getMessage(name) {
        return this.messagePrefix + '.' + Led.MESSAGE_PREFIX + '.' + name;
    }
}
exports.default = Led;
Led.MESSAGE_PREFIX = 'led';
//# sourceMappingURL=Led.js.map