"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const Led_1 = require("./Led/Led");
const SerialPort_1 = require("./SerialPort");
const BarcodeScanner_1 = require("./BarcodeScanner/BarcodeScanner");
class Hardware {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
        this.eventEmitter = new events_1.EventEmitter();
        this.led = new Led_1.default(this.getMessagePrefix(), this.postMessage);
        this.barcodeScanner = new BarcodeScanner_1.default(this.getMessagePrefix(), this.postMessage);
    }
    openSerialPort(options) {
        return __awaiter(this, void 0, void 0, function* () {
            const { refid } = yield this.postMessage({
                type: this.getMessage('serial_port.open'),
                options,
            });
            return new SerialPort_1.default(refid, this.eventEmitter, this.getMessagePrefix(), this.postMessage);
        });
    }
    handleMessageData(data) {
        switch (data.type) {
            case this.getMessage('serial_port.data'):
                this.eventEmitter.emit('serial_port.data.' + data.refid, data.data);
                break;
            default:
                this.barcodeScanner.handleMessageData(data);
        }
    }
    getMessage(name) {
        return this.getMessagePrefix() + '.' + name;
    }
    getMessagePrefix() {
        return this.messagePrefix + '.' + Hardware.MESSAGE_PREFIX;
    }
}
exports.default = Hardware;
Hardware.MESSAGE_PREFIX = 'hardware';
//# sourceMappingURL=Hardware.js.map