import IPostMessage from '../../IPostMessage';
import IBarcodeScannerDataMessage from './IBarcodeScannerDataMessage';
export declare const DEFAULT_SCANNER_ID = 0;
interface IBarcodeScannerOptions {
    timeout?: number;
    cancelPrevious?: boolean;
    scannerId?: number;
}
export default class BarcodeScanner {
    private messagePrefix;
    private postMessage;
    static MESSAGE_PREFIX: 'barcode_scanner';
    private eventEmitter;
    constructor(messagePrefix: string, postMessage: IPostMessage<any>);
    /**
     * @experimental
     */
    getVersion(): Promise<string>;
    /**
     * @experimental
     */
    start(userOptions?: Omit<IBarcodeScannerOptions, 'scannerId'>): Promise<{
        stop: () => Promise<void>;
        onData: (listener: (data: string) => void) => void;
        onError: (listener: (error: Error) => void) => void;
    }>;
    handleMessageData(msg: IBarcodeScannerDataMessage): void;
    private getMessage;
}
export {};
