import IMessage from './IMessage';
import Video from './Video/Video';
import Stream from './Stream/Stream';
import Offline from './Offline/Offline';
import Command from './Command/Command';
import Hardware from './Hardware/Hardware';
import Browser from './Browser/Browser';
import Iframe from './Iframe/Iframe';
import Touch from './Touch/Touch';
import Input from './Input/Input';
import Debug, { WeinreData } from './Debug/Debug';
import DeviceInfo from './DeviceInfo/DeviceInfo';
import Display from './Display/Display';
import Timing from './Timing/Timing';
import Sync from './Sync/Sync';
import FileSystem from './FileSystem/FileSystem';
import Management from './Management/Management';
import Monitors from './Monitors/Monitors';
import Sensors from './Sensors/Sensors';
import OSD from './OSD/OSD';
import ProofOfPlay from './ProofOfPlay/ProofOfPlay';
export default class FrontApplet {
    readonly window: Window & WeinreData;
    private messagePrefix;
    config: any | null;
    authHash: string | null;
    appletVersion: string | null;
    readonly debug: Debug;
    readonly deviceInfo: DeviceInfo;
    readonly display: Display;
    readonly apiJsUri: string;
    readonly stream: Stream;
    readonly video: Video;
    readonly command: Command;
    readonly hardware: Hardware;
    readonly offline: Offline;
    readonly browser: Browser;
    readonly iframe: Iframe;
    readonly touch: Touch;
    readonly input: Input;
    readonly timing: Timing;
    readonly sync: Sync;
    readonly fileSystem: FileSystem;
    readonly management: Management;
    readonly monitors: Monitors;
    readonly osd: OSD;
    readonly proofOfPlay: ProofOfPlay;
    readonly sensors: Sensors;
    private readyEmitter;
    private invocationResponseEmitter;
    private javascriptLoadFileController;
    constructor(window: Window & WeinreData, messagePrefix: string);
    postMessage(data: IMessage): Promise<any>;
    onReady(listener?: () => void): Promise<void>;
    restore(): void;
    refresh(): Promise<void>;
    private forwardRestoreToFrontAppletWindows;
    private removeMediaListeners;
    private checkIfReady;
    private handleMessage;
    private getMessage;
    private startPinging;
}
