"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createExchange = void 0;
function createExchange(messagePrefix, postMessage) {
    const messageNameToType = (name) => {
        return [messagePrefix, name].join('.');
    };
    const typedPostMessage = (message) => __awaiter(this, void 0, void 0, function* () {
        const type = messageNameToType(message.type);
        message = Object.assign(Object.assign({}, message), { type });
        return postMessage(message);
    });
    return {
        messageNameToType,
        postMessage: typedPostMessage,
        createNamespaced: (namespace) => createExchange(messageNameToType(namespace), postMessage),
    };
}
exports.createExchange = createExchange;
//# sourceMappingURL=Exchange.js.map