"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEnrichedStack = exports.createError = void 0;
const NO_STACK_MSG = 'Stack trace is not available for this type of error.';
function createError(errorTransferObject) {
    const { message } = errorTransferObject;
    const errorToReturn = new Error(message);
    errorToReturn.stack = getEnrichedStack(errorTransferObject);
    errorToReturn.name = errorTransferObject.type;
    Object.keys(errorTransferObject).forEach((key) => {
        errorToReturn[key] = errorTransferObject[key];
    });
    return errorToReturn;
}
exports.createError = createError;
function getEnrichedStack(error) {
    const { type, message, code, stackTrace, pathToDocs, origin, originStack } = error;
    const suggestion = getErrorSuggestion(code, error.suggestion, pathToDocs);
    let stringToReturn = '';
    stringToReturn += type + ': ' + message + '\n';
    stringToReturn += 'Code' + ': ' + code + '\n';
    stringToReturn += 'Suggestion' + ': ' + suggestion + '\n';
    stringToReturn += origin
        ? 'Origin' + ': ' + origin + '\n'
        : '';
    stringToReturn += originStack
        ? 'OriginStack' + ': ' + originStack + '\n'
        : (origin && !originStack)
            ? 'OriginStack' + ': ' + NO_STACK_MSG + '\n'
            : '';
    stringToReturn += stackTrace
        ? 'Stack' + ': ' + stackTrace
        : 'Stack' + ': ' + NO_STACK_MSG;
    return stringToReturn;
}
exports.getEnrichedStack = getEnrichedStack;
function getErrorSuggestion(code, suggestion, pathToDocs) {
    const DOCS_HOST_URL = 'https://docs.signageos.io';
    const BEFORE_LINK_MSG = 'More information on';
    let LINK_TO_ERROR;
    if (pathToDocs) {
        LINK_TO_ERROR = `${DOCS_HOST_URL}${pathToDocs}`;
    }
    else {
        LINK_TO_ERROR = `${DOCS_HOST_URL}/search?key=error%20${code}`;
    }
    let suggestionToReturn = suggestion ? suggestion + '\n' : '';
    suggestionToReturn += `${BEFORE_LINK_MSG} ${LINK_TO_ERROR}`;
    return suggestionToReturn;
}
//# sourceMappingURL=errorHelper.js.map