"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ErrorCodes_1 = require("./ErrorCodes");
const ErrorCodesMessages = {
    [ErrorCodes_1.default.UNEXPECTED_EXCEPTION]: 'Unexpected exception',
    [ErrorCodes_1.default.FILE_IS_NOT_JS_OBJECT]: 'File needs to be object',
    [ErrorCodes_1.default.FILE_DOES_NOT_HAVE_UID]: 'File uid needs to be defined',
    [ErrorCodes_1.default.FILE_FLAGS_ARE_NOT_IN_ARRAY]: 'File flags needs to be Array of objects',
    [ErrorCodes_1.default.FILE_FLAG_IS_NOT_OBJECT]: 'File flag needs to be object',
    [ErrorCodes_1.default.COMMAND_TYPE_NOT_VALID]: 'Type contains invalid characters.',
    [ErrorCodes_1.default.COMMAND_TYPE_IS_TOO_LONG]: 'Type is longer then 100 characters.',
    [ErrorCodes_1.default.HARDWARE_LED_COLOR_IS_NOT_STRING]: 'Color must be string',
    [ErrorCodes_1.default.HARDWARE_LED_COLOR_IS_NOT_VALID]: 'Color must be in format #000000 or null',
    [ErrorCodes_1.default.FILE_NOT_FOUND_IN_CACHE]: 'File was not found',
    [ErrorCodes_1.default.OFFLINE_CACHE_UID_NOT_VALID]: 'Uid contains invalid characters',
    [ErrorCodes_1.default.OFFLINE_CACHE_HEADERS_NOT_VALID]: 'Invalid headers',
    [ErrorCodes_1.default.STREAM_INVALID_PROTOCOL_TYPE]: 'Invalid stream protocol type',
    [ErrorCodes_1.default.VIDEO_WAS_NOT_PLAYED_YET]: 'This video was not played yet',
    [ErrorCodes_1.default.VIDEO_WAS_STOPPED_ALREADY]: 'This video was already stopped',
    [ErrorCodes_1.default.SECURITY_PIN_CODE_INVALID]: 'Invalid PIN code',
};
exports.default = ErrorCodesMessages;
//# sourceMappingURL=ErrorCodesMessages.js.map