"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sanitizeCoordinations = void 0;
function sanitizeCoordinations(input) {
    let x;
    let y;
    let width;
    let height;
    if (input.x === undefined || input.x === null) {
        x = 0;
    }
    else if (typeof input.x !== 'number') {
        x = parseInt(input.x);
    }
    else {
        x = Math.floor(input.x);
    }
    warnOrErrorWrongCoordination('x', x, input.x);
    if (input.y === undefined || input.y === null) {
        y = 0;
    }
    else if (typeof input.y !== 'number') {
        y = parseInt(input.y);
    }
    else {
        y = Math.floor(input.y);
    }
    warnOrErrorWrongCoordination('y', y, input.y);
    if (input.width === undefined || input.width === null) {
        width = 0;
    }
    else if (typeof input.width !== 'number') {
        width = parseInt(input.width);
    }
    else {
        width = Math.floor(input.width);
    }
    warnOrErrorWrongCoordination('width', width, input.width);
    if (input.height === undefined || input.height === null) {
        height = 0;
    }
    else if (typeof input.height !== 'number') {
        height = parseInt(input.height);
    }
    else {
        height = Math.floor(input.height);
    }
    warnOrErrorWrongCoordination('height', height, input.height);
    return {
        x,
        y,
        width,
        height,
    };
}
exports.sanitizeCoordinations = sanitizeCoordinations;
function warnOrErrorWrongCoordination(coordName, castedValue, value) {
    if (isNaN(castedValue)) {
        throw Error(`Coordination ${coordName}="${value}" is not valid number`);
    }
    else if (typeof castedValue !== typeof value) {
        console.warn(`Coordination ${coordName}="${value}" is not a typeof number but is typeof ${typeof value}. `
            + `Was automatically casted as "${castedValue}"`);
    }
    else if (castedValue !== value) {
        console.warn(`Coordination ${coordName}="${value}" is not an integer but is float. Was automatically floored to "${castedValue}"`);
    }
}
//# sourceMappingURL=coordinationsHelper.js.map