"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const Validate_1 = require("../Validate/Validate");
class Debug extends events_1.EventEmitter {
    constructor(window, messagePrefix, postMessage) {
        super();
        this.window = window;
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    isRemoteDebugEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            const { isEnabled } = yield this.postMessage({
                type: this.getMessage('is_remote_enabled'),
            });
            return isEnabled;
        });
    }
    onRemoteDebugChanged(listener) {
        Validate_1.default({ listener }).required().function();
        this.addListener(Debug.DEBUG_CHANGED, (data) => listener({ enabled: data.enabled }));
    }
    handleMessageData(data) {
        switch (data.type) {
            case this.getMessage("configure"):
                this.emit(Debug.DEBUG_CHANGED, {
                    enabled: data.enabled,
                });
                if (data.enabled) {
                    this.window.WeinreServerURL = data.url;
                    this.window.WeinreServerId = data.id;
                    if (!this.window.__weinreLoaded) {
                        require("weinre/web/target/target-script");
                        this.window.__weinreLoaded = true;
                    }
                }
                else {
                    this.window.WeinreServerURL = undefined;
                    this.window.WeinreServerId = undefined;
                }
                break;
            default:
        }
    }
    getMessage(name) {
        return this.messagePrefix + "." + Debug.MESSAGE_PREFIX + "." + name;
    }
}
exports.default = Debug;
Debug.MESSAGE_PREFIX = "debug";
Debug.DEBUG_CHANGED = "debug.changed";
//# sourceMappingURL=Debug.js.map