/// <reference types="node" />
import { EventEmitter } from "events";
import IPostMessage from "../IPostMessage";
import IMessage from "../IMessage";
interface IDebugSetWeinreMessage extends IMessage {
    enabled: boolean;
    url: string;
    id: string;
}
export interface WeinreData {
    __weinreLoaded?: boolean;
    WeinreServerURL?: string;
    WeinreServerId?: string;
}
export default class Debug extends EventEmitter {
    readonly window: Window & WeinreData;
    private messagePrefix;
    private postMessage;
    static MESSAGE_PREFIX: string;
    static DEBUG_CHANGED: string;
    constructor(window: Window & WeinreData, messagePrefix: string, postMessage: IPostMessage<any>);
    isRemoteDebugEnabled(): Promise<boolean>;
    onRemoteDebugChanged(listener: (data: {
        enabled: boolean;
    }) => void): void;
    handleMessageData(data: IDebugSetWeinreMessage): void;
    private getMessage;
}
export {};
