import ICommand from './ICommand';
import IPostMessage from '../IPostMessage';
import ICommandDispatchToAppletMessage from './ICommandDispatchToAppletMessage';
import ICommandEventListener from './ICommandEventListener';
export default class Command {
    private messagePrefix;
    private postMessage;
    static MESSAGE_PREFIX: string;
    private eventEmitter;
    constructor(messagePrefix: string, postMessage: IPostMessage<void>);
    dispatch<TCommand extends ICommand = ICommand>(command: TCommand): Promise<void>;
    onCommand<TCommand extends ICommand = ICommand>(listener: ICommandEventListener<TCommand>): void;
    handleMessageData(data: ICommandDispatchToAppletMessage): void;
    private getMessage;
    private checkTypeValidity;
}
