declare type Color = string;
export declare type ITheme = {
    base?: 'light' | 'dark';
    shape?: {
        cornerSize?: number;
    };
    colors?: {
        primary?: Color;
        background?: Color;
        control?: Color;
    };
    widgets?: {
        editAddress?: {
            colors?: {
                background?: Color;
                text?: Color;
            };
        };
        buttonClose?: {
            colors?: {
                background?: Color | '@primary';
                text?: Color;
                icon?: Color;
            };
            icon?: 'none' | 'exit_to_app' | 'close' | 'cancel';
            text?: string;
        };
        progress?: {
            color?: Color | '@primary';
        };
    };
};
export declare const VITheme: {
    base: {
        '?string': string[];
    };
    shape: {
        '?object': {
            cornerSize: string;
        };
    };
    colors: {
        '?object': {
            primary: string;
            background: string;
            control: string;
        };
    };
    widgets: {
        '?object': {
            editAddress: {
                '?object': {
                    colors: {
                        '?object': {
                            background: string;
                            text: string;
                        };
                    };
                };
            };
            buttonClose: {
                '?object': {
                    colors: {
                        '?object': {
                            background: string;
                            text: string;
                            icon: string;
                        };
                    };
                    icon: {
                        '?string': string[];
                    };
                    text: string;
                };
            };
            progress: {
                '?object': {
                    color: string;
                };
            };
        };
    };
};
/** @deprecated */
export interface IDeprecatedOpenLinkOptions {
    acl?: RegExp[];
    aclMode?: 'blacklist' | 'whitelist';
    readOnlyAddressBar?: boolean;
    idleTimeout?: number;
    theme?: ITheme;
}
interface IOpenLinkOptions {
    aclDomains?: string[];
    aclMode?: 'blacklist' | 'whitelist';
    readOnlyAddressBar?: boolean;
    idleTimeout?: number;
    coordinates?: {
        x: number;
        y: number;
        width: number;
        height: number;
    };
    theme?: ITheme;
    headlessMode?: boolean;
    clearData?: boolean;
    canUserClose?: boolean;
}
export default IOpenLinkOptions;
export declare const VIOpenLinkOptions: {
    aclDomains: {
        '?array': string;
    };
    aclMode: {
        '?string': string[];
    };
    readOnlyAddressBar: string;
    idleTimeout: string;
    coordinates: {
        '?object': {
            x: string;
            y: string;
            width: string;
            height: string;
        };
    };
    theme: {
        '?object': {
            base: {
                '?string': string[];
            };
            shape: {
                '?object': {
                    cornerSize: string;
                };
            };
            colors: {
                '?object': {
                    primary: string;
                    background: string;
                    control: string;
                };
            };
            widgets: {
                '?object': {
                    editAddress: {
                        '?object': {
                            colors: {
                                '?object': {
                                    background: string;
                                    text: string;
                                };
                            };
                        };
                    };
                    buttonClose: {
                        '?object': {
                            colors: {
                                '?object': {
                                    background: string;
                                    text: string;
                                    icon: string;
                                };
                            };
                            icon: {
                                '?string': string[];
                            };
                            text: string;
                        };
                    };
                    progress: {
                        '?object': {
                            color: string;
                        };
                    };
                };
            };
        };
    };
    headlessMode: string;
    clearData: string;
    canUserClose: string;
};
