"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const IOpenLinkOptions_1 = require("./IOpenLinkOptions");
const Validate_1 = require("../Validate/Validate");
const events_1 = require("./events");
const events_2 = require("events");
class Browser {
    constructor(exchange) {
        this.exchange = exchange;
        this.events = new events_2.EventEmitter();
    }
    open(uri, options = {}) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ uri }).required().uri();
            Validate_1.default({ options }).required().object(IOpenLinkOptions_1.VIOpenLinkOptions);
            const headlessMode = (_a = options.headlessMode) !== null && _a !== void 0 ? _a : true;
            yield this.exchange.postMessage(Object.assign(Object.assign({ uri }, options), { headlessMode, type: 'open' }));
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.exchange.postMessage({
                type: 'close',
            });
        });
    }
    /**
     * Find out when the browser is closed.
     * This can happen by an API call, by a user request or after a timeout.
     *
     * This doesn't fire between `open` calls or on subsequent `close` calls.
     *
     * @returns A callback which removes the listener.
     */
    onClose(listener) {
        Validate_1.default({ listener }).required().function();
        this.events.addListener(events_1.EventType.CLOSE, listener);
        return () => {
            this.events.removeListener(events_1.EventType.CLOSE, listener);
        };
    }
    handleMessageData(data) {
        switch (data.type) {
            case this.exchange.messageNameToType('closed'):
                const event = {
                    type: events_1.EventType.CLOSE,
                    reason: data.reason,
                };
                this.events.emit(events_1.EventType.CLOSE, event);
                break;
            default:
        }
    }
    /** @deprecated use sos.browser.open() instead */
    openLink(uri, options = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            console.warn('sos.browser.openLink() is deprecated and will be removed in the future versions. Use sos.browser.open() instead.');
            Validate_1.default({ uri }).required().uri();
            Validate_1.default({ options }).required().object();
            yield this.exchange.postMessage(Object.assign(Object.assign({ uri }, options), { headlessMode: false, type: 'open_link' }));
        });
    }
}
exports.default = Browser;
//# sourceMappingURL=Browser.js.map