---
title:  Debug
author: Krystof Woldrich
date:   24.4.2018
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
description: "[Management JS API] Management API debug lets you enable and disable debug mode."
---

# Debug
Management API debug lets you enable and disable debug mode.

## All methods

::: table-responsive
| Method  | Description | Supported since |
| ------ | -------- | :-------------: |
| `enable()` | Enable native debug on the device | 3.0 |
| `disable()` | Disable native debug on the device | 3.0 |
:::

## enable()
Method `enable()` enable the [Native debug](https://docs.signageos.io/hc/en-us/articles/4405238849938) on the device.

```javascript
await sos.management.debug.enable();
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/debug/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">How to enable debug on device</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## disable()
Method `disable()` disable the [Native debug](https://docs.signageos.io/hc/en-us/articles/4405238849938) on the device.

```javascript
await sos.management.debug.disable();
