---
title:  Time
author: Miroslav Behina
date:   1.4.2018
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
description: "[Management JS API] Management API time allows you to check your devices current time with a timezone and set current time with a timezone."
---

# Time
Management API time allows you to check your devices current time with a timezone and set current time with a timezone.

## All methods

::: table-responsive
| Method     | Description                                       | Supported since |
| ----------- | ------------------------------------------------- | :---------------: |
| `get()`       | Get current time settings                         | 4.0.0           |
| `setManual()` | Set manual datetime and timezone                  | 4.0.0           |
| `setNTP()`    | Configure NTP server and timezone                 | 4.0.0           |
| `set()`       | Set manual datetime and timezone (**DEPRECATED**) | 4.0.0           |
:::

## get()
Method `get()` lets you check for current time with time zone. 

### Javascript example
```javascript
const time = await sos.management.time.get();
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/time/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">How to manage time on device</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

<br>

### Example of response

When NTP is set:

```json
{
    "currentDate": Date("2019-04-01T01:11:11.111Z"),
    "timezone": "Asia/Tokyo",
    "ntpServer": "pool.ntp.org"
}
```

When NTP is not set:

```json
{
    "currentDate": Date("2019-04-01T01:11:11.111Z"),
    "timezone": "Asia/Tokyo"
}
```

## set()
Method `set()` lets you set manual time and timezone of the device.

::: alert alert--warning
This method is deprecated. Use `setManual()` instead.
:::

::: alert alert--info
Calling `set()` will disable NTP server settings.
:::

::: table-responsive
|      Param     |Type        | Required | Description                  |
| -------------- | ---------- | :---------: | ------------------- |
| `currentDate`    | Date       | <div class="red">Yes</div> | Datetime to set              |
| `timezone`       | String     | <div class="red">Yes</div> | Timezone to set. Accepted values are timezone names from [timezone database](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). |
:::

### Javascript example
```javascript
const currentDate = new Date();
const timezone = "Europe/Amsterdam";
await sos.management.time.set(currentDate, timezone);
```

::: alert alert--warning
Setting time and timezone has side effects:

| Platform    | Side effect                                  |
| ----------- | -------------------------------------------- |
| Tizen       | After calling this API, display **Reboots**! |
| webOS       | After calling this API, display **Reboots**! |
| RaspberryPi | After calling this API, RPi **Reboots backend server which can take up to 60 seconds**!<br /> During the reboot no JS API is available.<br />Always wait for Promise resolution. |
:::

## setManual()
Method `setManual()` lets you set manual time and timezone of the device.

::: alert alert--info
Calling `setManual()` will disable NTP server settings.
:::

::: table-responsive
|      Param     |Type        | Required | Description                  |
| -------------- | ---------- | :---------: | ------------------- |
| `currentDate`    | Date \| object | <div class="red">Yes</div> | Datetime to set              |
| `timezone`       | String     | <div class="red">Yes</div> | Timezone to set. Accepted values are timezone names from [timezone database](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). |
:::

### Javascript example
```javascript
const datetimeObj = {
    year: 2021,
    month: 12,
    day: 15,
    hour: 9,
    minute: 30,
    seconds: 0,
};
const timezone = "Europe/Amsterdam";
await sos.management.time.setManual(datetimeObj, timezone);

// Using Date is deprecated. Use the example above.
const currentDate = new Date();
const timezone = "Europe/Amsterdam";
await sos.management.time.setManual(currentDate, timezone);
```

::: alert alert--warning
Calling this method with currentDate as Date is deprecated.
You should call it with datetime object instead. See example code.
:::

::: alert alert--warning
Setting time and timezone has side effects:

| Platform    | Side effect                                  |
| ----------- | -------------------------------------------- |
| Tizen       | After calling this API, display **Reboots**! |
| webOS       | After calling this API, display **Reboots**! |
| RaspberryPi | After calling this API, RPi **Reboots backend server which can take up to 60 seconds**!<br /> During the reboot no JS API is available.<br />Always wait for Promise resolution. |
:::

## setNTP()
Method `setNTP()` lets you configure NTP server and timezone.

::: table-responsive
|      Param     |Type        | Required | Description                  |
| -------------- | ---------- | :----------: | ------------------ |
| `ntpServer`      | string     | <div class="red">Yes</div> | Address of the NTP server    |
| `timezone`       | string     | <div class="red">Yes</div> | Timezone to set. Accepted values are timezone names from [timezone database](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). |
:::

### Javascript example
```javascript
const ntpServer = "pool.ntp.org";
const timezone = "Europe/Amsterdam";
await sos.management.time.setNTP(ntpServer, timezone);
```

::: alert alert--warning
Setting NTP server and timezone has side effects:

| Platform    | Side effect                                  |
| ----------- | -------------------------------------------- |
| Tizen       | After calling this API, display **Reboots**!<br/><br/> Tizen has [**limited set of available timezones**. Read more here.](https://docs.signageos.io/hc/en-us/articles/4405381271314) |
| RaspberryPi | After calling this API, RPi **Reboots backend server which can take up to 60 seconds**!<br /> During the reboot no JS API is available.<br />Always wait for Promise resolution. |
:::
