---
title:  IR Remote control
author: Miroslav Behina
date:   1.4.2018
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
description: "[Management JS API] Remote control API allows you to enable, disable and check status of remote control of your device."
---

# IR Remote control
Remote control API allows you to enable, disable and check status of remote control of your device.

## All methods

::: table-responsive
| Method | Description | Supported since |
| ------ | ------ | -------- | :-------------: |
| `enable()` | Enables IR Remote control allows you to operate the device with IR Remote control (available alias `unlock()`) | 3.0.0 |
| `disable()` | Disables IR Remote control allows you to operate the device with IR Remote control (available alias `lock()`) | 3.0.0 |
| `isEnabled()` | Check is the IR Remote control is enabled or not (available alias `isLocked()`) | 3.0.0 |
::: table-responsive


## enable()
Method `enable()` allows for a simple on state of remote control on your device.

::: alert alert--danger
**Android Devices Attention Required:**
In order to prevent Android from displaying Android homepage and thus not showing your content, you must Enable Kiosk Mode (or Lock Remote Control) either through Box device settings or through API.

Always set the Remote Control Lock to `enable` after the deployment.
:::

```javascript
await sos.management.remoteControl.enable(); // Returns void
// or await sos.management.remoteControl.unlock();
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/remote/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Enable remote control on device</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## disable() 
Method `disable()` allows for a simple off state of remote control on your device.

```javascript
await sos.management.remoteControl.disable(); // Returns void
// or await sos.management.remoteControl.lock();
```

## isEnabled() 
Method `isEnabled()` allows to check whether the remote control is turned on or off.

```javascript
await sos.management.remoteControl.isEnabled(); // Returns boolean
// or await sos.management.remoteControl.isLocked();
```
