---
title:  Wi-Fi
author: Michal Artazov
date:   1.9.2020
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
description: "[Management JS API] Wi-Fi API allows you to configure Wi-Fi, if the device supports it."
---

# Wi-Fi

Wi-Fi API allows you to configure Wi-Fi, if the device supports it.

::: alert alert--warning
* Before using this API, ensure that the device supports Wi-Fi via `sos.management.supports("WIFI")`.
* More info about how to check it, you can find [**THERE**](/api/js/management/1-js-management#supports)
:::

## State management
Wi-Fi can be in several states. Depending on which state it is in, its behavior will vary. The 3 possible states are:

* DISABLED
* CLIENT
* AP

::: alert alert--info
It is only allowed to switch to another state when in the DISABLED state. It is not allowed to go directly from CLIENT to AP or vice versa.
:::

### DISABLED

Wi-Fi is disabled. The DISABLED state is persistent between reboots.

### CLIENT

Wi-Fi is in the client state, i.e. it is capable of connecting to a network, similarly to a phone or laptop.
CLIENT state is persistent between reboots with all of its configuration.

### AP

Wi-Fi is in access point state, i.e. it itself becomes a Wi-Fi network that others can connect to.
AP state is not persistent and on reboot the device will be in DISABLED state.

## Country settings

Different regulations apply to Wi-Fi communication in different countries.
Under normal circumstances, everything should work with default settings.
However, if you experience any problems, you might want to try changing Wi-Fi country configuration to your country.
See [`getCountry()`](/api/js/management/13-js-management-wifi#getcountry) and [`setCountry()`](/api/js/management/13-js-management-wifi#setcountry) methods.

## All methods

::: table-responsive
| Methods              | Description                                                        | Supported since |
| -------------------- | ------------------------------------------------------------------ | :---------------: |
| `isClientEnabled()`    | Is in CLIENT state?                                                | 4.3.0           |
| `enableClient()`       | Switch to CLIENT state                                             | 4.3.0           |
| `isAPEnabled()`        | Is in AP state?                                                    | 4.3.0           |
| `enableAP()`           | Switch to AP state                                                 | 4.3.0           |
| `disable()`            | Switch to DISABLED state                                           | 4.3.0           |
| `getConnectedTo()`     | When in CLIENT state, return which network it is connected to      | 4.3.0           |
| `connect()`            | When in CLIENT state, connect to a network                         | 4.3.0           |
| `disconnect()`         | When in CLIENT state, disconnect from a network                    | 4.3.0           |
| `getCountry()`         | Get which country Wi-Fi is configured for                          | 4.3.0           |
| `setCountry()`        | Configure Wi-Fi for a specific country                             | 4.3.0           |
| `scanDevices()`        | When in CLIENT or AP states, scan available networks               | 4.3.0           |
| `on()`                 | Call listener anytime an event is emitted                          | 4.3.0           |
| `once()`               | Call listener the first time an event is emitted                   | 4.3.0           |
| `removeListener()`     | Remove a listener previously registered via on() or once() methods | 4.3.0           |
| `removeAllListeners()` | Remove all listeners                                               | 4.3.0           |
:::

## Events

::: table-responsive
| Event               | Description                                              |
| ------------------- | -------------------------------------------------------- |
| `client_enabled`      | Wi-Fi was set to CLIENT state                            |
| `client_connected`    | Wi-Fi is in CLIENT state and connected to a network      |
| `client_disconnected` | Wi-Fi is in CLIENT state and disconnected from a network |
| `ap_enabled`          | Wi-Fi was set to AP state                                |
| `disabled`            | Wi-Fi was set to DISABLED state                          |
:::

## Examples
<div class="row d-flex align-content-stretch force-padding-10">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/wifi-access-point/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Applet with Wi-Fi Access Point</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## isClientEnabled()
Returns true, if Wi-Fi is in CLIENT state. Otherwise, returns false. 

### Javascript example
```javascript
const isClientEnabled = await sos.management.wifi.isClientEnabled();
if (isClientEnabled) {
    // do something
}
```

## enableClient()
Sets Wi-Fi to CLIENT state, meaning it has the ability to connect to a Wi-Fi network or scan available networks in the area.

::: alert alert--info
It is not allowed to call this method, when in AP state. You must first switch to **DISABLED** state.
:::

### Javascript example
```javascript
await sos.management.wifi.enableClient();
```

## isAPEnabled()
Returns true, if Wi-Fi is in AP state. Otherwise, returns false. 

### Javascript example
```javascript
const isAPEnabled = await sos.management.wifi.isAPEnabled();
if (isAPEnabled) {
    // do something
}
```

## enableAP()
Sets Wi-Fi to AP state, meaning the device will become a Wi-Fi network that other devices can connect to.
It will run in WPA-Personal mode. As such, it requires an SSID (network name) and password that other devices will use to connect.

::: alert alert--info
* It is not allowed to call this method when in CLIENT state. You must first switch to **DISABLED** state.
* Before calling this method, make sure the device supports Wi-Fi AP via `sos.management.supports("WIFI_AP")`
:::

::: table-responsive
| Param    | Type   | Required | Description                                                                                              |
| -------- | ------ | :----------: | ---------------------------------------------------------------------------------------------- |
| `ssid`     | String | <div class="red">Yes</div> | Device will be visible as a Wi-Fi network with this name. Max. allowed length is 32 characters.          |
| `password` | String | <div class="red">Yes</div> | Devices that wish to connect to this network will use this password. Must be between 8 and 32 characters. |
:::

### Javascript example
```javascript
await sos.management.wifi.enableAP("my_network", "secretPassword123#");
```

## disable()
Sets Wi-Fi to **DISABLED** state. All previously configured networks will be forgotten.

### Javascript example
```javascript
await sos.management.wifi.disable();
```

## getConnectedTo()
If connected to a Wi-Fi network, returns the name of the network. Otherwise, returns null.

::: alert alert--info
It is only allowed to call this method in CLIENT state.
:::

### Javascript example

```javascript
const connectedTo = await sos.management.wifi.getConnectedTo();
```

## connect()
Connect to a network.

::: alert alert--info
It is only allowed to call this method in the **CLIENT** state.
:::

::: table-responsive
| Param               | Type   | Required | Description                                 |
| ------------------- | ------ | :---------: | ---------------------------------- |
| `ssid`     | String | <div class="red">Yes</div> | Name of the network you want to connect to. |
| `password` | String | <div class="yellow">No</div> | Network's password.                         |
| `options`  | Object | <div class="yellow">No</div> | Additional options.                         |
:::

### Javascript example
```javascript
// network without password
await sos.management.wifi.connect('network1');

// or network with password
await sos.management.wifi.connect('network2', 'password123');

// connect to a hidden network
await sos.management.wifi.connect('network3', 'password123', { hidden: true });
```

## disconnect()
Disconnect from the network, if connected to one.

::: alert alert--info
It is only allowed to call this method in the **CLIENT** state.
:::

### Javascript example

```javascript
await sos.management.wifi.disconnect();
```

## getCountry()
Get currently configured country code. 

::: alert alert--info
It is not allowed to call this method in the **DISABLED** state.
:::

### Javascript example
```javascript
const countryCode = await sos.management.wifi.getCountry();
```

## setCountry()
Configure Wi-Fi for country-specific regulations. 

::: alert alert--info
It is not allowed to call this method in the **DISABLED** state.
:::

::: table-responsive
| Param       | Type   | Required | Description                                                                                             |
| ----------- | ------ | :-----------: | -------------------------------------------------------------------------------------------- |
| `countryCode` | String | <div class="red">Yes</div> |2-letter country code. See this [list of countries and their codes](https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes). |
:::

### Javascript example
```javascript
await sos.management.wifi.setCountry('ES');
```

## scanDevices()
Get list of available Wi-Fi networks in the area. 

::: alert alert--info
* It is only allowed to call this method in the **CLIENT** state.
* Before calling this method, make sure the device supports scanning via `sos.management.supports("WIFI_SCAN")`
:::

### Javascript example
```javascript
const devices = await sos.management.wifi.scanDevices();
```

## on()
Call a callback everytime an event is emitted.

::: table-responsive
| Param    | Type     | Required | Description                                                       |
| -------- | -------- | :--------------: |  --------------------------------------------------- |
| `event`    | String   | <div class="red">Yes</div> | Event name. See [events](/api/js/management/13-js-management-wifi#events) for valid event names.          |
| `listener` | Method | <div class="red">Yes</div> | Callback that will be called everytime the given event is emitted |
:::

### Javascript example
```javascript
sos.management.wifi.on('client_connected', () => {
    console.log('Wi-Fi is connected');
});
sos.management.wifi.on('client_disconnected', () => {
    console.log('Wi-Fi is disconnected');
});
```

## once()
Call a callback the first time an event is emitted.

::: table-responsive
| Param    | Type     | Required | Description                                                       |
| -------- | -------- | :------------: | ----------------------------------------------------- |
| `event`    | String   | <div class="red">Yes</div> | Event name. See [events](/api/js/management/13-js-management-wifi#events) for valid event names.          |
| `listener` | Method | <div class="red">Yes</div> | Callback that will be called everytime the given event is emitted |
:::

### Javascript example
```javascript
sos.management.wifi.once('client_connected', () => {
    console.log('Wi-Fi is connected');
});
sos.management.wifi.once('client_disconnected', () => {
    console.log('Wi-Fi is disconnected');
});
```

## removeListener()
Remove an event listener previously registered via [`on`](/api/js/management/13-js-management-wifi#on) or [`once`](/api/js/management/13-js-management-wifi#once).

::: table-responsive
| Param    | Type     | Required | Description                                                       |
| -------- | -------- | :----------: | ------------------------------------------------------- |
| `event`    | String   | <div class="red">Yes</div> | Event name. See [events](/api/js/management/13-js-management-wifi#events) for valid event names.          |
| `listener` | Method | <div class="red">Yes</div> | Callback that was previously registered |
:::

### Javascript example
```javascript
// first register a listener
const listener = () => {
    console.log('Wi-Fi is connected');
};
sos.management.wifi.on('client_connected', listener);

// then remove it
sos.management.wifi.removeListener('client_connected', listener);

// now if client_connected is emitted, the listener callback wouldn't be called anymore
```

## removeAllListeners()
Remove all listeners previously registered via [`on`](/api/js/management/13-js-management-wifi#on) or [`once`](/api/js/management/13-js-management-wifi#once), either for a specific event or for all events.

::: table-responsive
| Param            | Type   | Required | Description                                              |
| ---------------- | ------ | :--------: | -------------------------------------------------------- |
| `event` | String | <div class="yellow">No</div> | Event name. See [events](/api/js/management/13-js-management-wifi#events) for valid event names. |
:::

### Javascript example
```javascript
// first register a listener
sos.management.wifi.on('client_connected', () => {
   console.log('Wi-Fi is connected');
});

// then remove it
sos.management.wifi.removeAllListeners('client_connected');
// now if client_connected is emitted, the listener callback wouldn't be called anymore

// next remove all listeners
sos.management.wifi.removeAllListeners();
// now if any event is emitted, no listener callbacks would be called
```

### FAQ
- Do I need to reboot my RPi for the Wi-Fi changes to take place?<br>
No, the device will automatically adapt to any saved changes

- How can I tell if the device has successfuly connected to the network?<br>
Once the device starts the connecting process and sucessfully connects, 2 events will be emmited:<br>
    1. client_enabled
    1. client_connected