---
title:  Video Playback
author: Miroslav Behina
date:   22.11.2018
type:   js-api
tags:
- applet
- applet_api
- api
- js_api
description: "[Content JS API] We know how crucial video is for digital signage. So we made it easy. There are several methods you can use for video manipulation."
---

# Video Playback
We know how crucial video is for digital signage. So we made it easy. There are several methods you can use for video manipulation.

## All methods/events
::: table-responsive
| Methods/Events  | Description | Supported since |
| ----------------- | ----------- | ------ | :---------------: |
| `play()` | Start video playing | 1.0.3 |
| `prepare()` | Prepare next video | 1.0.3 |
| `pause()` | Pause video | 1.0.3 |
| `stop()` | Completely stop video | 1.0.3 |
| `resume()` | Continue in playing | 1.0.3 |
| `onceEnded()` | Wait until video ends | 1.0.29 |
| `onEnded()` | Event called when video ends | 1.0.3 |
| `onError()` | Event called when video emits error | 1.0.3 |
:::

::: alert alert--warning
First 5 parameters (uri, x, y, width, height) are unique identifiers for playing the video using play, stop, resume and pause methods.
:::

::: alert alert--info
If you want to play video in full screen mode, use x = y = 0 and width = document.documentElement.clientWidth and height = document.documentElement.clientHeight as setup parameters.
:::

## How it works
![Gapless video playback lifecycle](https://docs.signageos.io/hc/article_attachments/9093558407708)


## play()
Play method calls the internal player and starts the video in correct position.

### Parameters
::: table-responsive
| Param | Type | Required | Description |
| ------ | ------ | :--------: | -------- |
| `uri` | String | <div class="red">Yes</div> | Address to remote (online) or local video file |
| `x` | Number | <div class="red">Yes</div> | 	x-position for video on screen |
| `y` | Number | <div class="red">Yes</div> |	y-position for video on screen |
| `width` | Number | <div class="red">Yes</div> | 	Video width on screen |
| `height` | Number | <div class="red">Yes</div> | Video height on screen |
:::

### Javascript
```javascript
await sos.video.play(uri, x, y, width, height);
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/video-loop-one">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Play one video in endless loop</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

<div class="row d-flex align-content-stretch force-padding-10">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/video-multiple">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Play multiple videos in endless loop</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

<div class="row d-flex align-content-stretch force-padding-10">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/video-and-images">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Switching video and images in endless loop</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## prepare()
Prepare method calls the internal player and preload the video into memory.

::: alert alert--info
Using `prepare()` is mandatory for gapless playback
:::

::: alert alert--warning
`4k` parameter is no longer needed since Front-display v7.5.0, Tizen Core App v2.1.0.  
`volume` is supported only on the RaspberryPi.
:::

### Parameters
::: table-responsive
| Param | Type | Required | Description |
| ------ | ------ | :--------: | -------- |
| `uri` | String | <div class="red">Yes</div> | Address to remote /online/ or local video file |
| `x` | Number | <div class="red">Yes</div> | 	x-position for video on screen |
| `y` | Number | <div class="red">Yes</div> |	y-position for video on screen |
| `width` | Number | <div class="red">Yes</div> | 	Video width on screen |
| `height` | Number | <div class="red">Yes</div> | Video height on screen |
| `options` | Object | <div class="yellow">No</div> | Additional video properties |
:::

### Options properties
::: table-responsive
| Property | Type | Required | Description |
| ------- | ------ | :------:| -----------|
| `4k` | Boolean | <div class="yellow">No</div> | Support for 4k video |
|^^|^^|^^| Deprecated since Tizen Core App v2.1.0 |
| `background` | Boolean | <div class="yellow">No</div> |  Bring video behind the applet html (similar to z-index: -1) |
| `volume` | Number | <div class="yellow">No</div> | Adjust volume of playing video itself (doesn't adjust display speaker volume) |
|^^|^^|^^| Supported only on **RaspberryPi** |
:::

### Javascript
```javascript
// playing video
await sos.video.prepare(uri, x, y, width, height);
// or advanced usage
await sos.video.prepare(uri, x, y, width, height, {
	'4k': true,
	background: true,
	volume: 60,
});
```

## stop(), pause() and resume()
All these methods call the internal player. All variables are mandatory in order to ensure video identification.

### Parameters
::: table-responsive
| Param | Type | Required | Description |
| ------ | ------ | :--------: | -------- |
| `uri` | String | <div class="red">Yes</div> | Address to remote (online) or local video file |
| `x` | Number | <div class="red">Yes</div> | 	x-position for video on screen |
| `y` | Number | <div class="red">Yes</div> |	y-position for video on screen |
| `width` | Number | <div class="red">Yes</div> | 	Video width on screen |
| `height` | Number | <div class="red">Yes</div> | Video height on screen |
:::

### Javascript
```javascript
// stop video
await sos.video.stop(uri, x, y, width, height);
 
// pause
await sos.video.pause(uri, x, y, width, height);
 
// resume
await sos.video.resume(uri, x, y, width, height);
```

## Event onceEnded
Wait until one specific video is ended.

### Parameters
::: table-responsive
| Param | Type | Required | Description |
| ------ | ------ | :--------: | -------- |
| `uri` | String | <div class="red">Yes</div> | Address to remote (online) or local video file |
| `x` | Number | <div class="red">Yes</div> | 	x-position for video on screen |
| `y` | Number | <div class="red">Yes</div> |	y-position for video on screen |
| `width` | Number | <div class="red">Yes</div> | 	Video width on screen |
| `height` | Number | <div class="red">Yes</div> | Video height on screen |
:::

### Javascript
```javascript
// wai on end of video
await sos.video.onceEnded(uri, x, y, width, height);
```

## Events onEnded, onError
All events about played videos can be binded using above mentioned methods. It will emit all events of all playing videos. Video source of emited event can be identified by srcArguments object available in event.

Listener method added as argument accepts event object. It contains these properties:

::: table-responsive
| Property | Description |
| ------ | ------ |
| `type` |	Type of event which can be ended or error string |
| `srcArguments` |	Arguments which was passed to play method.<br> Contains uri, x, y, width & height. |
:::

### Javascript
```javascript
// detect video ended
await sos.video.onEnded((event) => { console.log(event); });
 
// detect video error
await sos.video.onError((event) => { console.log(event); });
```

## Usage with Typescript
You can also use all these methods with [signageOS TypeScript](https://docs.signageos.io/hc/en-us/articles/4405069154962#signageos-typescript).

```typescript
play(
	uri: string,
	x: number,
	y: number,
	width: number,
	height: number
): Promise<void>;
prepare(
	uri: string,
	x: number,
	y: number,
	width: number,
	height: number,
	options?: {
		'4k'?: boolean;
		background?: boolean;
		volume?: number;
	}
): Promise<void>;
stop(
	uri: string,
	x: number,
	y: number,
	width: number,
	height: number
): Promise<void>;
pause(
	uri: string,
	x: number,
	y: number,
	width: number,
	height: number
): Promise<void>;
resume(
	uri: string,
	x: number,
	y: number,
	width: number,
	height: number
): Promise<void>;
```

## Errors
Although we are doing our best, following errors may occur when working with the video stream.

::: table-responsive
| Code | Type | Message |
| ---- | ---- | ------- |
| 41501 | AppletVideoError | This video was not played yet. The arguments: `arguments` |
| 51501 | InternalVideoError | Couldn't play the video. |
| 51502 | InternalVideoError | Couldn't prepare the video. |
| 51503 | InternalVideoError | Couldn't stop the video. |
| 51504 | InternalVideoError | Couldn't pause the video. |
| 51505 | InternalVideoError | Couldn't resume the video. |
:::
