---
title:  Sensors
author: Michal Artazov
date:   28.9.2020
type:   js-api
tags:
- applet
- applet_api
- api
- js_api
- sensors
description: "[Content JS API] We don't directly provide any sensors API but we provide a set of tools to implement your own integration of the hardware that you want to use."
---

# Sensors

We don't directly provide any sensors API but we provide a set of tools to implement your own integration of
the hardware that you want to use.

## Sensors interfaces

We provide a set of interfaces, that any integration should implement.
If every implementation implements the same set of interfaces, it's easy to swap it for a different implementation.
It also requires less code to be written to use various types of hardware.
If possible, you should always implement these interfaces.

::: alert alert--info
Right now, the list of interfaces is very short. We will be adding more types soon.
If there's any particular type of interfaces you'd like, kindly let us know.
:::

### Button

A regular button, that can be pressed or released.

```typescript
interface IButton {
    isPressed(): Promise<boolean>;
    on(event: 'pressed' | 'released', listener: () => void): void;
}
```

### RFID Antenna

Antenna that detects presence of RFID tags. An RFID tag is simply a number.
Whenever a tag is placed at close proximity to the antenna, it will emit a `placed` event.
Whenever a tag is picked and is no longer detected by the antenna, it will emit a `picked` event.

```typescript
interface IRfidAntenna {
	getPlacedTags(): Promise<number[]>;
	on(event: 'picked' | 'placed', listener: (rfidTag: number) => void): void;
}
```

## Ready to use integrations

We already did the hard work for you and implemented some of the popular hardware. All you have to do is use it in your project.
For more information read [this article](https://docs.signageos.io/hc/en-us/articles/4405231196946-Supported-devices-for-Sensors-usage).

## Writing your own implementation

Sometimes you might want to use hardware that we don't support out of the box yet.

Firstly, you will need to read the documentation for the [serial API](/api/js/content/js-hardware-serial).
Most often, the hardware you will decide to use connects to the device via USB and internally uses a serial communication, like RS232.
In that case you will use the serial API.

You can approach this any way you like, but remember that you should always implement the [interfaces defined by us](/api/js/content/js-sensors#sensors-interfaces).
That will allow for greater code reusability and readability.
